/*
 * Decompiled with CFR 0.152.
 */
package inter.cobrancav3.cobranca;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.cobrancav3.model.RequisicaoEmitirCobranca;
import inter.cobrancav3.model.RespostaEmitirCobranca;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.utils.HttpUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmiteCobranca {
    private static final Logger log = LoggerFactory.getLogger(EmiteCobranca.class);

    public RespostaEmitirCobranca emitir(Config config, RequisicaoEmitirCobranca requisicaoEmitirCobranca) throws SdkException {
        log.info("EmitirCobranca {} {}", (Object)config.getClientId(), (Object)requisicaoEmitirCobranca.getSeuNumero());
        String url = "https://cdpj.partners.AMBIENTE.com.br/cobranca/v3/cobrancas".replace("AMBIENTE", config.getAmbiente());
        try {
            String json = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)requisicaoEmitirCobranca);
            json = HttpUtils.callPost(config, url, "boleto-cobranca.write", "Erro ao emitir cobran\u00e7a", json);
            return (RespostaEmitirCobranca)new ObjectMapper().readValue(json, RespostaEmitirCobranca.class);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }
}

