/*
 * Decompiled with CFR 0.152.
 */
package inter.cobrancav3.cobranca;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.cobrancav3.model.CobrancaRecuperada;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.utils.HttpUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecuperaCobranca {
    private static final Logger log = LoggerFactory.getLogger(RecuperaCobranca.class);

    public CobrancaRecuperada recuperar(Config config, String codigoSolicitacao) throws SdkException {
        log.info("RecuperarCobranca {} codigoSolicitacao={}", (Object)config.getClientId(), (Object)codigoSolicitacao);
        String url = "https://cdpj.partners.AMBIENTE.com.br/cobranca/v3/cobrancas".replace("AMBIENTE", config.getAmbiente()) + "/" + codigoSolicitacao;
        String json = HttpUtils.callGet(config, url, "boleto-cobranca.read", "Erro ao recuperar cobran\u00e7a");
        try {
            return (CobrancaRecuperada)new ObjectMapper().readValue(json, CobrancaRecuperada.class);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }
}

