/*
 * Decompiled with CFR 0.152.
 */
package inter.cobrancav3.cobranca;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.cobrancav3.model.FiltroRecuperarSumarioCobrancas;
import inter.cobrancav3.model.Sumario;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.utils.HttpUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecuperaSumarioCobrancas {
    private static final Logger log = LoggerFactory.getLogger(RecuperaSumarioCobrancas.class);

    public Sumario recuperar(Config config, String dataInicial, String dataFinal, FiltroRecuperarSumarioCobrancas filtro) throws SdkException {
        log.info("RecuperarSumarioCobrancas {} {}-{}", new Object[]{config.getClientId(), dataInicial, dataFinal});
        String url = "https://cdpj.partners.AMBIENTE.com.br/cobranca/v3/cobrancas/sumario".replace("AMBIENTE", config.getAmbiente()) + "?dataInicial=" + dataInicial + "&dataFinal=" + dataFinal + this.addfilters(filtro);
        String json = HttpUtils.callGet(config, url, "boleto-cobranca.read", "Erro ao recuperar sum\u00e1rio de cobrancas");
        try {
            return (Sumario)new ObjectMapper().readValue(json, Sumario.class);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }

    private String addfilters(FiltroRecuperarSumarioCobrancas filtro) {
        if (filtro == null) {
            return "";
        }
        StringBuilder filter = new StringBuilder();
        if (filtro.getFiltrarDataPor() != null) {
            filter.append("&filtrarDataPor").append("=").append(filtro.getFiltrarDataPor().toString());
        }
        if (filtro.getSituacao() != null) {
            filter.append("&situacao").append("=").append(filtro.getSituacao().toString());
        }
        if (filtro.getPessoaPagadora() != null) {
            filter.append("&pessoaPagadora").append("=").append(filtro.getPessoaPagadora());
        }
        if (filtro.getCpfCnpjPessoaPagadora() != null) {
            filter.append("&cpfCnpjPessoaPagadora").append("=").append(filtro.getCpfCnpjPessoaPagadora());
        }
        if (filtro.getSeuNumero() != null) {
            filter.append("&seuNumero").append("=").append(filtro.getSeuNumero());
        }
        if (filtro.getTipoCobranca() != null) {
            filter.append("&tipoCobranca").append("=").append((Object)filtro.getTipoCobranca());
        }
        return filter.toString();
    }
}

