/*
 * Decompiled with CFR 0.152.
 */
package inter.cobrancav3.webhook;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.model.Webhook;
import inter.utils.HttpUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObtemWebhook {
    private static final Logger log = LoggerFactory.getLogger(ObtemWebhook.class);

    public Webhook obter(Config config) throws SdkException {
        log.info("ObterWebhook cobran\u00e7aV3 {}", (Object)config.getClientId());
        String url = "https://cdpj.partners.AMBIENTE.com.br/cobranca/v3/cobrancas/webhook".replace("AMBIENTE", config.getAmbiente());
        String json = HttpUtils.callGet(config, url, "boleto-cobranca.read", "Erro ao obter webhook");
        try {
            return (Webhook)new ObjectMapper().readValue(json, Webhook.class);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }
}

