/*
 * Decompiled with CFR 0.152.
 */
package inter.oauth;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.RespostaObterToken;
import inter.utils.HttpUtils;
import inter.utils.SslUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.BasicHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObterToken {
    private static final Logger log = LoggerFactory.getLogger(ObterToken.class);

    public RespostaObterToken obter(Config config, String escopos) throws IOException, SdkException, UnrecoverableKeyException, CertificateException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, ParseException {
        log.info("ObterToken {} {}", (Object)config.getClientId(), (Object)escopos);
        BasicHttpClientConnectionManager connectionManager = SslUtils.buildConnectionManager(config.getCertificado(), config.getSenha());
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        String url = "https://cdpj.partners.AMBIENTE.com.br/oauth/v2/token".replace("AMBIENTE", config.getAmbiente());
        HttpPost request = new HttpPost(url);
        ArrayList<BasicNameValuePair> prms = new ArrayList<BasicNameValuePair>();
        prms.add(new BasicNameValuePair("client_id", config.getClientId()));
        prms.add(new BasicNameValuePair("client_secret", config.getClientSecret()));
        prms.add(new BasicNameValuePair("grant_type", "client_credentials"));
        prms.add(new BasicNameValuePair("scope", escopos));
        request.setEntity((HttpEntity)new UrlEncodedFormEntity(prms, StandardCharsets.UTF_8));
        request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
        CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)request);
        HttpUtils.handleResponse(url, response, "Erro ao obter token", config.isControleRateLimit());
        HttpEntity body = response.getEntity();
        String json = EntityUtils.toString((HttpEntity)body, (String)"UTF-8");
        RespostaObterToken respostaToken = (RespostaObterToken)new ObjectMapper().readValue(json, RespostaObterToken.class);
        respostaToken.setCreatedAt(LocalDateTime.now().toEpochSecond(ZoneOffset.UTC));
        return respostaToken;
    }
}

