/*
 * Decompiled with CFR 0.152.
 */
package inter.pix.cob;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.pix.model.CobrancaDetalhada;
import inter.pix.model.FiltroConsultarCobrancasImediatas;
import inter.pix.model.PaginaCobrancas;
import inter.utils.HttpUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsultarCobrancasImediatas {
    private static final Logger log = LoggerFactory.getLogger(ConsultarCobrancasImediatas.class);

    public PaginaCobrancas consultar(Config config, String dataInicial, String dataFinal, int pagina, Integer tamanhoPagina, FiltroConsultarCobrancasImediatas filtro) throws SdkException {
        log.info("ConsultarCobrancasImediatas {} {}-{} pagina={}", new Object[]{config.getClientId(), dataInicial, dataFinal, pagina});
        return this.getPage(config, dataInicial, dataFinal, pagina, tamanhoPagina, filtro);
    }

    public List<CobrancaDetalhada> consultar(Config config, String dataInicial, String dataFinal, FiltroConsultarCobrancasImediatas filtro) throws SdkException {
        PaginaCobrancas paginaCobrancas;
        log.info("ConsultarCobrancasImediatas {} {}-{}", new Object[]{config.getClientId(), dataInicial, dataFinal});
        int pagina = 0;
        ArrayList<CobrancaDetalhada> cobrancas = new ArrayList<CobrancaDetalhada>();
        do {
            paginaCobrancas = this.getPage(config, dataInicial, dataFinal, pagina, null, filtro);
            cobrancas.addAll(paginaCobrancas.getCobrancas());
        } while (++pagina < paginaCobrancas.getQuantidadeDePaginas());
        return cobrancas;
    }

    private PaginaCobrancas getPage(Config config, String dataInicial, String dataFinal, int pagina, Integer tamanhoPagina, FiltroConsultarCobrancasImediatas filtro) throws SdkException {
        String url = "https://cdpj.partners.AMBIENTE.com.br/pix/v2/cob".replace("AMBIENTE", config.getAmbiente()) + "?inicio=" + dataInicial + "&fim=" + dataFinal + "&paginacao.paginaAtual=" + pagina + (String)(tamanhoPagina != null ? "&paginacao.itensPorPagina=" + tamanhoPagina : "") + this.addfilters(filtro);
        String json = HttpUtils.callGet(config, url, "cob.read", "Erro ao consultar cobran\u00e7as imediatas");
        try {
            return (PaginaCobrancas)new ObjectMapper().readValue(json, PaginaCobrancas.class);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }

    private String addfilters(FiltroConsultarCobrancasImediatas filtro) {
        if (filtro == null) {
            return "";
        }
        StringBuilder filter = new StringBuilder();
        if (filtro.getCpf() != null) {
            filter.append("&cpf").append("=").append(filtro.getCpf());
        }
        if (filtro.getCnpj() != null) {
            filter.append("&cnpj").append("=").append(filtro.getCnpj());
        }
        if (filtro.getLocationPresente() != null) {
            filter.append("&locationPresente").append("=").append(filtro.getLocationPresente());
        }
        if (filtro.getStatus() != null) {
            filter.append("&status").append("=").append(filtro.getStatus().toString());
        }
        return filter.toString();
    }
}

