/*
 * Decompiled with CFR 0.152.
 */
package inter.pix.cob;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.pix.model.Cobranca;
import inter.pix.model.CobrancaDetalhada;
import inter.utils.HttpUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CriarCobrancaImediata {
    private static final Logger log = LoggerFactory.getLogger(CriarCobrancaImediata.class);

    public CobrancaDetalhada criar(Config config, Cobranca cobranca) throws SdkException {
        log.info("CriarCobrancaImediata {} {}", (Object)config.getClientId(), (Object)cobranca.getTxid());
        Object url = "https://cdpj.partners.AMBIENTE.com.br/pix/v2/cob".replace("AMBIENTE", config.getAmbiente());
        try {
            String json = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)cobranca);
            if (cobranca.getTxid() == null) {
                json = HttpUtils.callPost(config, (String)url, "cob.write", "Erro ao criar cobran\u00e7a imediata", json);
            } else {
                url = (String)url + "/" + cobranca.getTxid();
                json = HttpUtils.callPut(config, (String)url, "cob.write", "Erro ao criar cobran\u00e7a imediata", json);
            }
            return (CobrancaDetalhada)new ObjectMapper().readValue(json, CobrancaDetalhada.class);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }
}

