/*
 * Decompiled with CFR 0.152.
 */
package inter.pix.cobv;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.pix.model.CobrancaVencimentoDetalhada;
import inter.utils.HttpUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsultarCobrancaComVencimento {
    private static final Logger log = LoggerFactory.getLogger(ConsultarCobrancaComVencimento.class);

    public CobrancaVencimentoDetalhada consultar(Config config, String txId) throws SdkException {
        log.info("ConsultarCobrancaComVencimento {} txId={}", (Object)config.getClientId(), (Object)txId);
        String url = "https://cdpj.partners.AMBIENTE.com.br/pix/v2/cobv".replace("AMBIENTE", config.getAmbiente()) + "/" + txId;
        String json = HttpUtils.callGet(config, url, "cobv.read", "Erro ao consultar cobran\u00e7a com vencimento");
        try {
            return (CobrancaVencimentoDetalhada)new ObjectMapper().readValue(json, CobrancaVencimentoDetalhada.class);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }
}

