/*
 * Decompiled with CFR 0.152.
 */
package inter.pix.cobv;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.pix.model.CobrancaVencimento;
import inter.pix.model.CobrancaVencimentoDetalhada;
import inter.utils.HttpUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CriarCobrancaComVencimento {
    private static final Logger log = LoggerFactory.getLogger(CriarCobrancaComVencimento.class);

    public CobrancaVencimentoDetalhada criar(Config config, String txid, CobrancaVencimento cobranca) throws SdkException {
        log.info("CriarCobrancaComVencimento {} {}", (Object)config.getClientId(), (Object)txid);
        String url = "https://cdpj.partners.AMBIENTE.com.br/pix/v2/cobv".replace("AMBIENTE", config.getAmbiente()) + "/" + txid;
        try {
            String json = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)cobranca);
            json = HttpUtils.callPut(config, url, "cobv.write", "Erro ao criar cobran\u00e7a com vencimento", json);
            return (CobrancaVencimentoDetalhada)new ObjectMapper().readValue(json, CobrancaVencimentoDetalhada.class);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }
}

