/*
 * Decompiled with CFR 0.152.
 */
package inter.pix.location;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.pix.model.FiltroConsultarLocations;
import inter.pix.model.Location;
import inter.pix.model.PaginaLocations;
import inter.utils.HttpUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsultarLocationsCadastradas {
    private static final Logger log = LoggerFactory.getLogger(ConsultarLocationsCadastradas.class);

    public PaginaLocations consultar(Config config, String dataInicial, String dataFinal, int pagina, Integer tamanhoPagina, FiltroConsultarLocations filtro) throws SdkException {
        log.info("ConsultarLocationsCadastradas {} {}-{} pagina={}", new Object[]{config.getClientId(), dataInicial, dataFinal, pagina});
        return this.getPage(config, dataInicial, dataFinal, pagina, tamanhoPagina, filtro);
    }

    public List<Location> consultar(Config config, String dataInicial, String dataFinal, FiltroConsultarLocations filtro) throws SdkException {
        PaginaLocations paginaLocations;
        log.info("ConsultarLocationsCadastradas {} {}-{}", new Object[]{config.getClientId(), dataInicial, dataFinal});
        int pagina = 0;
        ArrayList<Location> locs = new ArrayList<Location>();
        do {
            paginaLocations = this.getPage(config, dataInicial, dataFinal, pagina, null, filtro);
            locs.addAll(paginaLocations.getLocs());
        } while (++pagina < paginaLocations.getQuantidadeDePaginas());
        return locs;
    }

    private PaginaLocations getPage(Config config, String dataInicial, String dataFinal, int pagina, Integer tamanhoPagina, FiltroConsultarLocations filtro) throws SdkException {
        String url = "https://cdpj.partners.AMBIENTE.com.br/pix/v2/loc".replace("AMBIENTE", config.getAmbiente()) + "?inicio=" + dataInicial + "&fim=" + dataFinal + "&paginacao.paginaAtual=" + pagina + (String)(tamanhoPagina != null ? "&paginacao.itensPorPagina=" + tamanhoPagina : "") + this.addfilters(filtro);
        String json = HttpUtils.callGet(config, url, "payloadlocation.read", "Erro ao consultar locations");
        try {
            return (PaginaLocations)new ObjectMapper().readValue(json, PaginaLocations.class);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }

    private String addfilters(FiltroConsultarLocations filtro) {
        if (filtro == null) {
            return "";
        }
        StringBuilder filter = new StringBuilder();
        if (filtro.getTxIdPresente() != null) {
            filter.append("&txIdPresente").append("=").append(filtro.getTxIdPresente());
        }
        if (filtro.getTipoCob() != null) {
            filter.append("&tipoCob").append("=").append(filtro.getTipoCob().toString());
        }
        return filter.toString();
    }
}

