/*
 * Decompiled with CFR 0.152.
 */
package inter.pix.location;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.pix.model.CriarLocationRequest;
import inter.pix.model.Location;
import inter.pix.model.enums.TipoCob;
import inter.utils.HttpUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CriarLocation {
    private static final Logger log = LoggerFactory.getLogger(CriarLocation.class);

    public Location criar(Config config, TipoCob tipoCob) throws SdkException {
        log.info("CriarLocation pix {} {}", (Object)config.getClientId(), (Object)tipoCob);
        String url = "https://cdpj.partners.AMBIENTE.com.br/pix/v2/loc".replace("AMBIENTE", config.getAmbiente());
        CriarLocationRequest request = CriarLocationRequest.builder().tipoCob(tipoCob).build();
        try {
            String json = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)request);
            json = HttpUtils.callPost(config, url, "payloadlocation.write", "Erro ao criar location", json);
            return (Location)new ObjectMapper().readValue(json, Location.class);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }
}

