/*
 * Decompiled with CFR 0.152.
 */
package inter.pix.location;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.pix.model.Location;
import inter.utils.HttpUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecuperarLocation {
    private static final Logger log = LoggerFactory.getLogger(RecuperarLocation.class);

    public Location recuperar(Config config, String id) throws SdkException {
        log.info("RecuperarLocation {} id={}", (Object)config.getClientId(), (Object)id);
        String url = "https://cdpj.partners.AMBIENTE.com.br/pix/v2/loc".replace("AMBIENTE", config.getAmbiente()) + "/" + id;
        String json = HttpUtils.callGet(config, url, "payloadlocation.read", "Erro ao recuperar location");
        try {
            return (Location)new ObjectMapper().readValue(json, Location.class);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }
}

