/*
 * Decompiled with CFR 0.152.
 */
package inter.pix.pix;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.pix.model.DevolucaoDetalhada;
import inter.utils.HttpUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsultarDevolucao {
    private static final Logger log = LoggerFactory.getLogger(ConsultarDevolucao.class);

    public DevolucaoDetalhada consultar(Config config, String e2eId, String id) throws SdkException {
        log.info("ConsultarDevolucao {} e2eId={} id={}", new Object[]{config.getClientId(), e2eId, id});
        String url = "https://cdpj.partners.AMBIENTE.com.br/pix/v2/pix".replace("AMBIENTE", config.getAmbiente()) + "/" + e2eId + "/devolucao/" + id;
        String json = HttpUtils.callGet(config, url, "pix.read", "Erro ao consultar devolu\u00e7\u00e3o");
        try {
            return (DevolucaoDetalhada)new ObjectMapper().readValue(json, DevolucaoDetalhada.class);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }
}

