/*
 * Decompiled with CFR 0.152.
 */
package inter.pix.pix;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.pix.model.FiltroConsultarPixRecebidos;
import inter.pix.model.PaginaPix;
import inter.pix.model.Pix;
import inter.utils.HttpUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsultarPixRecebidos {
    private static final Logger log = LoggerFactory.getLogger(ConsultarPixRecebidos.class);

    public PaginaPix consultar(Config config, String dataInicial, String dataFinal, int pagina, Integer tamanhoPagina, FiltroConsultarPixRecebidos filtro) throws SdkException {
        log.info("ConsultarPixRecebidos {} {}-{} pagina={}", new Object[]{config.getClientId(), dataInicial, dataFinal, pagina});
        return this.getPage(config, dataInicial, dataFinal, pagina, tamanhoPagina, filtro);
    }

    public List<Pix> consultar(Config config, String dataInicial, String dataFinal, FiltroConsultarPixRecebidos filtro) throws SdkException {
        PaginaPix paginaPix;
        log.info("ConsultarPixRecebidos {} {}-{}", new Object[]{config.getClientId(), dataInicial, dataFinal});
        int pagina = 0;
        ArrayList<Pix> listaPix = new ArrayList<Pix>();
        do {
            paginaPix = this.getPage(config, dataInicial, dataFinal, pagina, null, filtro);
            listaPix.addAll(paginaPix.getListaPix());
        } while (++pagina < paginaPix.getQuantidadeDePaginas());
        return listaPix;
    }

    private PaginaPix getPage(Config config, String dataInicial, String dataFinal, int pagina, Integer tamanhoPagina, FiltroConsultarPixRecebidos filtro) throws SdkException {
        String url = "https://cdpj.partners.AMBIENTE.com.br/pix/v2/pix".replace("AMBIENTE", config.getAmbiente()) + "?inicio=" + dataInicial + "&fim=" + dataFinal + "&paginacao.paginaAtual=" + pagina + (String)(tamanhoPagina != null ? "&paginacao.itensPorPagina=" + tamanhoPagina : "") + this.addfilters(filtro);
        String json = HttpUtils.callGet(config, url, "pix.read", "Erro ao consultar pix recebidos");
        try {
            return (PaginaPix)new ObjectMapper().readValue(json, PaginaPix.class);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }

    private String addfilters(FiltroConsultarPixRecebidos filtro) {
        if (filtro == null) {
            return "";
        }
        StringBuilder filter = new StringBuilder();
        if (filtro.getTxId() != null) {
            filter.append("&txId").append("=").append(filtro.getTxId());
        }
        if (filtro.getTxIdPresente() != null) {
            filter.append("&txIdPresente").append("=").append(filtro.getTxIdPresente());
        }
        if (filtro.getDevolucaoPresente() != null) {
            filter.append("&devolucaoPresente").append("=").append(filtro.getDevolucaoPresente());
        }
        if (filtro.getCpf() != null) {
            filter.append("&cpf").append("=").append(filtro.getCpf());
        }
        if (filtro.getCnpj() != null) {
            filter.append("&cnpj").append("=").append(filtro.getCnpj());
        }
        if (filtro.getTxId() != null) {
            filter.append("&txId").append("=").append(filtro.getTxId());
        }
        return filter.toString();
    }
}

