/*
 * Decompiled with CFR 0.152.
 */
package inter.pix.webhook;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.pix.model.FiltroBuscarCallbacks;
import inter.pix.model.PaginaCallbacks;
import inter.pix.model.RespostaBuscarCallbacks;
import inter.utils.HttpUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsultarCallbacks {
    private static final Logger log = LoggerFactory.getLogger(ConsultarCallbacks.class);

    public PaginaCallbacks buscar(Config config, String dataHoraInicio, String dataHoraFim, int pagina, Integer tamanhoPagina, FiltroBuscarCallbacks filtro) throws SdkException {
        log.info("ConsultarCallbacks {} {}-{}", new Object[]{config.getClientId(), dataHoraInicio, dataHoraFim});
        return this.getPage(config, dataHoraInicio, dataHoraFim, pagina, tamanhoPagina, filtro);
    }

    public List<RespostaBuscarCallbacks> buscar(Config config, String dataInicial, String dataFinal, FiltroBuscarCallbacks filtro) throws SdkException {
        PaginaCallbacks paginaCallbacks;
        log.info("ConsultarCallbacks {} {}-{}", new Object[]{config.getClientId(), dataInicial, dataFinal});
        int pagina = 0;
        ArrayList<RespostaBuscarCallbacks> callbacks = new ArrayList<RespostaBuscarCallbacks>();
        do {
            paginaCallbacks = this.getPage(config, dataInicial, dataFinal, pagina, null, filtro);
            callbacks.addAll(paginaCallbacks.getData());
        } while (++pagina < paginaCallbacks.getTotalPaginas());
        return callbacks;
    }

    private PaginaCallbacks getPage(Config config, String dataHoraInicio, String dataHoraFim, int pagina, Integer tamanhoPagina, FiltroBuscarCallbacks filtro) throws SdkException {
        String url = "https://cdpj.partners.AMBIENTE.com.br/pix/v2/webhook/callbacks".replace("AMBIENTE", config.getAmbiente()) + "?dataHoraInicio=" + dataHoraInicio + "&dataHoraFim=" + dataHoraFim + "&pagina=" + pagina + (String)(tamanhoPagina != null ? "&tamanhoPagina=" + tamanhoPagina : "") + this.addfilters(filtro);
        String json = HttpUtils.callGet(config, url, "webhook.read", "Erro ao recuperar callbacks");
        try {
            return (PaginaCallbacks)new ObjectMapper().readValue(json, PaginaCallbacks.class);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }

    private String addfilters(FiltroBuscarCallbacks filtro) {
        if (filtro == null) {
            return "";
        }
        StringBuilder filter = new StringBuilder();
        if (filtro.getTxid() != null) {
            filter.append("&txid").append("=").append(filtro.getTxid());
        }
        return filter.toString();
    }
}

