/*
 * Decompiled with CFR 0.152.
 */
package inter.pix.webhook;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.CriarWebhookRequest;
import inter.model.Erro;
import inter.utils.HttpUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CriarWebhook {
    private static final Logger log = LoggerFactory.getLogger(CriarWebhook.class);

    public void criar(Config config, String webhookUrl, String chave) throws SdkException {
        log.info("CriarWebhook pix {} {} {}", new Object[]{config.getClientId(), webhookUrl, chave});
        String url = "https://cdpj.partners.AMBIENTE.com.br/pix/v2/webhook".replace("AMBIENTE", config.getAmbiente()) + "/" + chave;
        CriarWebhookRequest request = CriarWebhookRequest.builder().webhookUrl(webhookUrl).build();
        try {
            String json = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)request);
            HttpUtils.callPut(config, url, "webhook.write", "Erro ao criar webhook", json);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }
}

