/*
 * Decompiled with CFR 0.152.
 */
package inter.pix.webhook;

import com.fasterxml.jackson.databind.ObjectMapper;
import inter.exceptions.SdkException;
import inter.model.Config;
import inter.model.Erro;
import inter.model.Webhook;
import inter.utils.HttpUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObterWebhook {
    private static final Logger log = LoggerFactory.getLogger(ObterWebhook.class);

    public Webhook obter(Config config, String chave) throws SdkException {
        log.info("ObterWebhook pix {} {}", (Object)config.getClientId(), (Object)chave);
        String url = "https://cdpj.partners.AMBIENTE.com.br/pix/v2/webhook".replace("AMBIENTE", config.getAmbiente()) + "/" + chave;
        String json = HttpUtils.callGet(config, url, "webhook.read", "Erro ao obter webhook");
        try {
            return (Webhook)new ObjectMapper().readValue(json, Webhook.class);
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
    }
}

