/*
 * Decompiled with CFR 0.152.
 */
package inter.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import inter.exceptions.CertificadoException;
import inter.exceptions.ClientException;
import inter.exceptions.SdkException;
import inter.exceptions.ServerException;
import inter.model.Config;
import inter.model.Erro;
import inter.utils.SslUtils;
import inter.utils.TokenUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.BasicHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);
    private static final int SLEEP = 60000;
    private static final int CLIENT_ERROR_BASE = 400;
    private static final int SERVER_ERROR_BASE = 500;
    private static final int TOO_MANY_REQUESTS = 429;
    private static final String APPLICATION_JSON = "application/json";
    private static String lastUrl;
    private static String lastRequest;

    private HttpUtils() {
    }

    public static String callGet(Config config, String url, String scope, String message) throws SdkException {
        log.info("http GET {}", (Object)url);
        HttpGet httpGet = new HttpGet(url);
        return HttpUtils.call(config, (HttpUriRequestBase)httpGet, url, scope, message);
    }

    public static String callPut(Config config, String url, String scope, String message, String json) throws SdkException {
        log.info("http PUT {}", (Object)url);
        HttpPut httpPut = new HttpPut(url);
        httpPut.addHeader("Content-Type", (Object)APPLICATION_JSON);
        httpPut.setEntity((HttpEntity)new StringEntity(json, StandardCharsets.UTF_8));
        if (config.isDebug()) {
            log.info(json);
        }
        lastRequest = json;
        return HttpUtils.call(config, (HttpUriRequestBase)httpPut, url, scope, message);
    }

    public static String callPatch(Config config, String url, String scope, String message, String json) throws SdkException {
        log.info("http PATCH {}", (Object)url);
        HttpPatch httpPatch = new HttpPatch(url);
        httpPatch.addHeader("Content-Type", (Object)APPLICATION_JSON);
        httpPatch.setEntity((HttpEntity)new StringEntity(json, StandardCharsets.UTF_8));
        if (config.isDebug()) {
            log.info(json);
        }
        lastRequest = json;
        return HttpUtils.call(config, (HttpUriRequestBase)httpPatch, url, scope, message);
    }

    public static String callPost(Config config, String url, String scope, String message, String json) throws SdkException {
        log.info("http POST {}", (Object)url);
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", (Object)APPLICATION_JSON);
        httpPost.setEntity((HttpEntity)new StringEntity(json, StandardCharsets.UTF_8));
        if (config.isDebug()) {
            log.info(json);
        }
        lastRequest = json;
        return HttpUtils.call(config, (HttpUriRequestBase)httpPost, url, scope, message);
    }

    public static String callDelete(Config config, String url, String scope, String message) throws SdkException {
        log.info("http DELETE {}", (Object)url);
        HttpDelete httpDelete = new HttpDelete(url);
        return HttpUtils.call(config, (HttpUriRequestBase)httpDelete, url, scope, message);
    }

    private static String call(Config config, HttpUriRequestBase httpRequest, String url, String scope, String message) throws SdkException {
        try {
            String result;
            lastUrl = url;
            String accessToken = TokenUtils.obter(config, scope);
            BasicHttpClientConnectionManager connectionManager = SslUtils.buildConnectionManager(config.getCertificado(), config.getSenha());
            CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
            httpRequest.addHeader("Authorization", (Object)("Bearer " + accessToken));
            if (config.getContaCorrente() != null) {
                httpRequest.addHeader("x-conta-corrente", (Object)config.getContaCorrente());
            }
            httpRequest.addHeader("x-inter-sdk", (Object)"java");
            httpRequest.addHeader("x-inter-sdk-version", (Object)"1.0.2");
            CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)httpRequest);
            boolean retry = HttpUtils.handleResponse(url, response, message, config.isControleRateLimit());
            if (retry) {
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                return HttpUtils.call(config, httpRequest, url, scope, message);
            }
            HttpEntity body = response.getEntity();
            String string = result = body != null ? EntityUtils.toString((HttpEntity)body, (Charset)StandardCharsets.UTF_8) : null;
            if (config.isDebug() && result != null) {
                log.info(result);
            }
            return result;
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            log.error("Erro no Certificado!", (Throwable)e);
            throw new CertificadoException(e.getMessage(), Erro.builder().title("Erro no Certificado!").detail(e.getMessage()).build());
        }
        catch (IOException ioException) {
            log.error("Erro durante execu\u00e7\u00e3o do SDK!", (Throwable)ioException);
            throw new SdkException(ioException.getMessage(), Erro.builder().title("Erro no Certificado!").detail(ioException.getMessage()).build());
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean handleResponse(String url, CloseableHttpResponse response, String message, boolean rateLimitControl) throws SdkException, IOException, ParseException {
        log.info("http status={} {}", (Object)response.getCode(), (Object)url);
        if (response.getCode() >= 500) {
            HttpEntity body = response.getEntity();
            String json = EntityUtils.toString((HttpEntity)body, (Charset)StandardCharsets.UTF_8);
            ServerException e = new ServerException(message, json.isEmpty() ? Erro.builder().title(String.valueOf(response.getCode())).build() : (Erro)new ObjectMapper().readValue(json, Erro.class));
            HttpUtils.logAndThrowException(e);
        } else if (response.getCode() >= 400) {
            Erro erro;
            if (response.getCode() == 429 && rateLimitControl) {
                return true;
            }
            HttpEntity body = response.getEntity();
            String json = EntityUtils.toString((HttpEntity)body, (Charset)StandardCharsets.UTF_8);
            try {
                erro = json.isEmpty() ? Erro.builder().title(String.valueOf(response.getCode())).build() : (Erro)new ObjectMapper().readValue(json, Erro.class);
            }
            catch (JsonProcessingException e) {
                erro = Erro.builder().title(String.valueOf(response.getCode())).build();
            }
            ClientException e = new ClientException(message, erro);
            HttpUtils.logAndThrowException(e);
        }
        return false;
    }

    private static void logAndThrowException(SdkException e) throws SdkException {
        log.error(e.getErro().getTitle(), (Throwable)e);
        log.error(e.getErro().getDetail());
        if (e.getErro().getViolacoes() != null) {
            e.getErro().getViolacoes().forEach(v -> log.error(v.toString()));
        }
        throw e;
    }

    public static String getLastUrl() {
        return lastUrl;
    }

    public static String getLastRequest() {
        return lastRequest;
    }
}

