/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.resource;

import br.com.moip.MoipException;
import br.com.moip.MoipHttp;
import br.com.moip.ValidationException;
import br.com.moip.resource.Customer;
import br.com.moip.resource.MoipResource;
import br.com.moip.resource.Payment;
import br.com.moip.resource.Refund;
import br.com.moip.resource.structure.Address;
import br.com.moip.resource.structure.Amount;
import br.com.moip.resource.structure.Entry;
import br.com.moip.resource.structure.Errors;
import br.com.moip.resource.structure.Event;
import br.com.moip.resource.structure.Item;
import br.com.moip.resource.structure.Receiver;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Order
extends MoipResource {
    private String id;
    private String ownId;
    private List<Item> items = new ArrayList<Item>();
    private String status;
    private String createdAt;
    private Amount amount = new Amount();
    private List<Address> addresses;
    private Customer customer;
    private List<Payment> payments;
    private List<Refund> refunds;
    private List<Entry> entries;
    private List<Event> events;
    private List<Receiver> receivers;
    private String updatedAt;
    private String ERROR;
    private List<Errors> errors;

    public Order addAddress(String type, String street, String number, String district, String city, String state, String zip, String complement, String country) {
        Address address = new Address();
        address.setType(type);
        address.setStreet(street);
        address.setStreetNumber(number);
        address.setDistrict(district);
        address.setCity(city);
        address.setState(state);
        address.setZipCode(zip);
        address.setComplement(complement);
        address.setCountry(country);
        this.addresses.add(address);
        return this;
    }

    public Order addItem(String product, Integer quantity, String detail, Integer price) {
        Item item = new Item();
        item.setProduct(product);
        item.setQuantity(quantity);
        item.setDetail(detail);
        item.setPrice(price);
        this.items.add(item);
        return this;
    }

    public Order addReceiver(String moipAccount, Integer amount) {
        return this.addReceiver(moipAccount, amount, "SECONDARY");
    }

    public Order addReceiver(String moipAccount, Integer amount, String type) {
        Receiver receiver = new Receiver();
        receiver.getMoipAccount().setId(moipAccount);
        receiver.setType(type);
        receiver.getAmount().setFixed(amount);
        if (this.receivers == null) {
            this.receivers = new ArrayList<Receiver>();
        }
        this.receivers.add(receiver);
        return this;
    }

    public Order create() {
        Gson gson = new Gson();
        MoipHttp moipHttp = this.moip.getMoipHttp();
        String json = moipHttp.sendRequest("/v2/orders", "POST", gson.toJson((Object)this));
        Order order = (Order)gson.fromJson(json, Order.class);
        order.setMoip(this.moip);
        if (order.hasUnexpectedError()) {
            throw new MoipException();
        }
        if (order.hasValidationError()) {
            throw new ValidationException(order.getErrors());
        }
        return order;
    }

    public Order get(String id) {
        Gson gson = new Gson();
        MoipHttp moipHttp = this.moip.getMoipHttp();
        String json = moipHttp.sendRequest("/v2/orders/" + id, "GET");
        Order order = (Order)gson.fromJson(json, Order.class);
        order.setMoip(this.moip);
        return order;
    }

    public String getId() {
        return this.id;
    }

    public String getOwnId() {
        return this.ownId;
    }

    public Order setOwnId(String ownId) {
        this.ownId = ownId;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public Order setStatus(String status) {
        this.status = status;
        return this;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public Order setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public Amount getAmount() {
        return this.amount;
    }

    public Order setAmount(Amount amount) {
        this.amount = amount;
        return this;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public Order setCustomer(Customer customer) {
        this.customer = customer;
        return this;
    }

    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public Order setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    public Integer getShippingAmount() {
        return this.amount.getSubtotals().getShipping();
    }

    public Order setShippingAmount(Integer amount) {
        this.amount.getSubtotals().setShipping(amount);
        return this;
    }

    public Iterator<Entry> getEntryIterator() {
        if (this.entries == null) {
            this.entries = new ArrayList<Entry>();
        }
        return this.entries.iterator();
    }

    public Iterator<Refund> getRefundIterator() {
        if (this.refunds == null) {
            this.refunds = new ArrayList<Refund>();
        }
        return this.refunds.iterator();
    }

    public Iterator<Event> getEventIterator() {
        if (this.events == null) {
            this.events = new ArrayList<Event>();
        }
        return this.events.iterator();
    }

    public Iterator<Payment> getPaymentIterator() {
        if (this.payments == null) {
            this.payments = new ArrayList<Payment>();
        }
        Iterator<Payment> i = this.payments.iterator();
        while (i.hasNext()) {
            i.next().setOrder(this);
        }
        return this.payments.iterator();
    }

    public Payment payments() {
        Payment payment = new Payment();
        payment.setMoip(this.moip);
        payment.setOrder(this);
        return payment;
    }

    public Refund refund() {
        Refund refund = new Refund();
        refund.setMoip(this.moip);
        refund.setOrder(this);
        return refund;
    }

    public String getERROR() {
        return this.ERROR;
    }

    public void setERROR(String ERROR) {
        this.ERROR = ERROR;
    }

    public boolean hasUnexpectedError() {
        return this.getERROR() != null;
    }

    public List<Errors> getErrors() {
        return this.errors;
    }

    public void setErrors(List<Errors> errors) {
        this.errors = errors;
    }

    public boolean hasValidationError() {
        return this.getErrors() != null;
    }

    public String toString() {
        return "Order{id='" + this.id + '\'' + ", ownId='" + this.ownId + '\'' + ", items=" + this.items + ", status='" + this.status + '\'' + ", createdAt='" + this.createdAt + '\'' + ", amount=" + this.amount + ", addresses=" + this.addresses + ", customer=" + this.customer + ", payments=" + this.payments + ", refunds=" + this.refunds + ", entries=" + this.entries + ", events=" + this.events + ", receivers=" + this.receivers + ", updatedAt='" + this.updatedAt + '\'' + ", ERROR='" + this.ERROR + '\'' + ", errors=" + this.errors + '}';
    }
}

