/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.resource;

import br.com.moip.MoipException;
import br.com.moip.MoipHttp;
import br.com.moip.ValidationException;
import br.com.moip.resource.MoipResource;
import br.com.moip.resource.Multiorder;
import br.com.moip.resource.Order;
import br.com.moip.resource.Refund;
import br.com.moip.resource.links.Links;
import br.com.moip.resource.structure.Amount;
import br.com.moip.resource.structure.Boleto;
import br.com.moip.resource.structure.CreditCard;
import br.com.moip.resource.structure.Errors;
import br.com.moip.resource.structure.Event;
import br.com.moip.resource.structure.Fee;
import br.com.moip.resource.structure.FundingInstrument;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Payment
extends MoipResource {
    private String id;
    private String status;
    private Amount amount;
    private Integer installmentCount = 1;
    private FundingInstrument fundingInstrument;
    private List<Fee> fees;
    private List<Event> events;
    private String updatedAt;
    private String createdAt;
    private Links _links;
    private String ERROR;
    private List<Errors> errors;
    private transient Order order;
    private transient Multiorder multiorder;

    public void setId(String id) {
        this.id = id;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public FundingInstrument getFundingInstrument() {
        return this.fundingInstrument;
    }

    public void setFundingInstrument(FundingInstrument fundingInstrument) {
        this.fundingInstrument = fundingInstrument;
    }

    public List<Fee> getFees() {
        return this.fees;
    }

    public void setFees(List<Fee> fees) {
        this.fees = fees;
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public void setEvents(List<Event> events) {
        this.events = events;
    }

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public Order getOrder() {
        return this.order;
    }

    public Multiorder getMultiorder() {
        return this.multiorder;
    }

    public Payment get(String id) {
        if (this.order != null || this.multiorder != null) {
            Gson gson = new Gson();
            String path = this.multiorder == null ? "/v2/payments/" + id : "/v2/multipayments/" + id;
            MoipHttp moipHttp = this.moip.getMoipHttp();
            String json = moipHttp.sendRequest(path, "GET");
            Payment payment = (Payment)gson.fromJson(json, Payment.class);
            payment.setMoip(this.moip);
            return payment;
        }
        return this;
    }

    public Payment execute() {
        Gson gson = new Gson();
        String path = this.multiorder == null ? "/v2/orders/" + this.order.getId() + "/payments" : "/v2/multiorders/" + this.multiorder.getId() + "/multipayments";
        MoipHttp moipHttp = this.moip.getMoipHttp();
        String json = moipHttp.sendRequest(path, "POST", gson.toJson((Object)this));
        Payment payment = (Payment)gson.fromJson(json, Payment.class);
        if (payment.hasUnexpectedError()) {
            throw new MoipException();
        }
        if (payment.hasValidationError()) {
            throw new ValidationException(payment.getErrors());
        }
        payment.setMoip(this.moip);
        return payment;
    }

    public Amount getAmount() {
        return this.amount;
    }

    public Payment setAmount(Amount amount) {
        this.amount = amount;
        return this;
    }

    public Integer getInstallmentCount() {
        return this.installmentCount;
    }

    public Payment setInstallmentCount(Integer installmentCount) {
        this.installmentCount = installmentCount;
        return this;
    }

    public Payment setCreditCard(CreditCard creditCard) {
        this.fundingInstrument = new FundingInstrument();
        this.fundingInstrument.setCreditCard(creditCard);
        return this;
    }

    public Payment setBoleto(Boleto boleto) {
        this.fundingInstrument = new FundingInstrument();
        this.fundingInstrument.setBoleto(boleto);
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getStatus() {
        return this.status;
    }

    public Iterator<Event> getEventIterator() {
        if (this.events == null) {
            this.events = new ArrayList<Event>();
        }
        return this.events.iterator();
    }

    public Iterator<Fee> getFeeIterator() {
        if (this.fees == null) {
            this.fees = new ArrayList<Fee>();
        }
        return this.fees.iterator();
    }

    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public Payment setOrder(Order order) {
        this.order = order;
        return this;
    }

    public Payment setMultiorder(Multiorder multiorder) {
        this.multiorder = multiorder;
        return this;
    }

    public Refund refund() {
        Refund refund = new Refund();
        refund.setMoip(this.moip);
        refund.setPayment(this);
        return refund;
    }

    public Links get_links() {
        return this._links;
    }

    public void set_links(Links _links) {
        this._links = _links;
    }

    public boolean hasValidationError() {
        return this.getErrors() != null && !this.getErrors().isEmpty();
    }

    public boolean hasUnexpectedError() {
        return this.getERROR() != null;
    }

    public String getERROR() {
        return this.ERROR;
    }

    public void setERROR(String ERROR) {
        this.ERROR = ERROR;
    }

    public List<Errors> getErrors() {
        return this.errors;
    }

    public void setErrors(List<Errors> errors) {
        this.errors = errors;
    }

    public String toString() {
        return "Payment{id='" + this.id + '\'' + ", status='" + this.status + '\'' + ", amount=" + this.amount + ", installmentCount=" + this.installmentCount + ", fundingInstrument=" + this.fundingInstrument + ", fees=" + this.fees + ", events=" + this.events + ", updatedAt='" + this.updatedAt + '\'' + ", createdAt='" + this.createdAt + '\'' + ", _links=" + this._links + ", errors=" + this.errors + ", order=" + this.order + ", multiorder=" + this.multiorder + '}';
    }
}

