/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.api;

import br.com.moip.Client;
import br.com.moip.api.filter.Filters;
import br.com.moip.api.filter.Pagination;
import br.com.moip.request.OrderRequest;
import br.com.moip.resource.Order;
import br.com.moip.response.OrderListResponse;
import br.com.moip.util.QueryStringFactory;
import java.util.HashMap;
import java.util.Map;

public class OrderAPI {
    private final Client client;
    private static final String PATH = "/v2/orders";

    public OrderAPI(Client client) {
        this.client = client;
    }

    public Order create(OrderRequest order) {
        return this.client.post(PATH, order, Order.class);
    }

    public Order get(String id) {
        return this.client.get(String.format("%s/%s", PATH, id), Order.class);
    }

    public OrderListResponse list() {
        return this.client.get(PATH, OrderListResponse.class);
    }

    public OrderListResponse list(Pagination pagination) {
        String path = new QueryStringFactory(PATH, pagination, null, null).generate();
        return this.client.get(path, OrderListResponse.class);
    }

    public OrderListResponse list(Filters filters) {
        return this.client.get(new QueryStringFactory(PATH, null, filters, null).generate(), OrderListResponse.class);
    }

    public OrderListResponse list(String queryParam) {
        return this.client.get(new QueryStringFactory(PATH, null, null, this.hashParams(queryParam)).generate(), OrderListResponse.class);
    }

    public OrderListResponse list(Pagination pagination, Filters filters) {
        return this.client.get(new QueryStringFactory(PATH, pagination, filters, null).generate(), OrderListResponse.class);
    }

    public OrderListResponse list(Pagination pagination, String queryParam) {
        return this.client.get(new QueryStringFactory(PATH, pagination, null, this.hashParams(queryParam)).generate(), OrderListResponse.class);
    }

    public OrderListResponse list(Filters filters, String queryParam) {
        return this.client.get(new QueryStringFactory(PATH, null, filters, this.hashParams(queryParam)).generate(), OrderListResponse.class);
    }

    public OrderListResponse list(Pagination pagination, Filters filters, String qParam) {
        return this.client.get(new QueryStringFactory(PATH, pagination, filters, this.hashParams(qParam)).generate(), OrderListResponse.class);
    }

    private Map<String, String> hashParams(final String queryParam) {
        return new HashMap<String, String>(){
            {
                this.put("q", queryParam);
            }
        };
    }
}

