/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip;

import br.com.moip.Client;
import br.com.moip.api.AccountAPI;
import br.com.moip.api.BalancesAPI;
import br.com.moip.api.BankAccountsAPI;
import br.com.moip.api.ConnectAPI;
import br.com.moip.api.CustomerAPI;
import br.com.moip.api.EntryAPI;
import br.com.moip.api.EscrowAPI;
import br.com.moip.api.InvoiceAPI;
import br.com.moip.api.MultiorderAPI;
import br.com.moip.api.MultipaymentAPI;
import br.com.moip.api.NotificationPreferencesAPI;
import br.com.moip.api.OrderAPI;
import br.com.moip.api.PaymentAPI;
import br.com.moip.api.RefundAPI;
import br.com.moip.api.TransferApi;

public class API {
    private final Client client;

    public API(Client client) {
        this.client = client;
    }

    public OrderAPI order() {
        return new OrderAPI(this.client);
    }

    public PaymentAPI payment() {
        return new PaymentAPI(this.client);
    }

    public InvoiceAPI invoice() {
        return new InvoiceAPI(this.client);
    }

    public AccountAPI account() {
        return new AccountAPI(this.client);
    }

    public CustomerAPI customer() {
        return new CustomerAPI(this.client);
    }

    public ConnectAPI connect() {
        if (this.client.getEndpoint() == "https://api.moip.com.br") {
            return new ConnectAPI(new Client("https://connect.moip.com.br", this.client.getAuthentication()));
        }
        return new ConnectAPI(new Client("https://connect-sandbox.moip.com.br", this.client.getAuthentication()));
    }

    public NotificationPreferencesAPI notification() {
        return new NotificationPreferencesAPI(this.client);
    }

    public RefundAPI refund() {
        return new RefundAPI(this.client);
    }

    public MultiorderAPI multiorder() {
        return new MultiorderAPI(this.client);
    }

    public MultipaymentAPI multipayment() {
        return new MultipaymentAPI(this.client);
    }

    public BankAccountsAPI bankAccount() {
        return new BankAccountsAPI(this.client);
    }

    public EscrowAPI escrow() {
        return new EscrowAPI(this.client);
    }

    public TransferApi transfer() {
        return new TransferApi(this.client);
    }

    public EntryAPI entry() {
        return new EntryAPI(this.client);
    }

    public BalancesAPI balance() {
        return new BalancesAPI(this.client);
    }
}

