/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.api;

import br.com.moip.Client;
import br.com.moip.api.filter.Filters;
import br.com.moip.api.filter.Pagination;
import br.com.moip.resource.Entry;
import br.com.moip.response.EntriesListResponse;
import br.com.moip.util.QueryStringFactory;
import java.util.HashMap;
import java.util.Map;

public class EntryAPI {
    private final Client client;
    private static final String PATH = "/v2/entries";

    public EntryAPI(Client client) {
        this.client = client;
    }

    public Entry get(String externalId) {
        return this.client.get(String.format("%s/%s", PATH, externalId), Entry.class);
    }

    public EntriesListResponse list() {
        return this.client.get(PATH, EntriesListResponse.class);
    }

    public EntriesListResponse list(Pagination pagination) {
        return this.client.get(new QueryStringFactory(PATH, pagination, null, null).generate(), EntriesListResponse.class);
    }

    public EntriesListResponse list(Filters filter) {
        return this.client.get(new QueryStringFactory(PATH, null, filter, null).generate(), EntriesListResponse.class);
    }

    public EntriesListResponse list(String queryParam) {
        return this.client.get(new QueryStringFactory(PATH, null, null, this.hashParams(queryParam)).generate(), EntriesListResponse.class);
    }

    public EntriesListResponse list(Pagination pagination, Filters filters) {
        return this.client.get(new QueryStringFactory(PATH, pagination, filters, null).generate(), EntriesListResponse.class);
    }

    public EntriesListResponse list(Pagination pagination, String queryParam) {
        return this.client.get(new QueryStringFactory(PATH, pagination, null, this.hashParams(queryParam)).generate(), EntriesListResponse.class);
    }

    public EntriesListResponse list(Filters filters, String queryParam) {
        return this.client.get(new QueryStringFactory(PATH, null, filters, this.hashParams(queryParam)).generate(), EntriesListResponse.class);
    }

    public EntriesListResponse list(Pagination pagination, Filters filters, String queryParam) {
        return this.client.get(new QueryStringFactory(PATH, pagination, filters, this.hashParams(queryParam)).generate(), EntriesListResponse.class);
    }

    private Map<String, String> hashParams(final String queryParam) {
        return new HashMap<String, String>(){
            {
                this.put("q", queryParam);
            }
        };
    }
}

