/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code;

import br.com.objectos.code.HasNameInfo;
import br.com.objectos.code.TypeInfo;
import com.google.common.collect.ImmutableSet;
import com.google.common.truth.SubjectFactory;
import com.google.common.truth.Truth;
import com.google.testing.compile.JavaFileObjects;
import com.google.testing.compile.JavaSourcesSubject;
import com.google.testing.compile.JavaSourcesSubjectFactory;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

public abstract class AbstractTestingProcessor
extends AbstractProcessor {
    private Map<String, TypeInfo> qualifiedNameMap;

    public static <T extends AbstractTestingProcessor> Map<String, TypeInfo> loadAll(Supplier<T> supplier, String basePath, String ... paths) {
        List objectList = Stream.of(paths).map(input -> JavaFileObjects.forResource((String)(basePath + "/" + input))).collect(Collectors.toList());
        AbstractTestingProcessor processor = (AbstractTestingProcessor)supplier.get();
        ((JavaSourcesSubject)Truth.ASSERT.about((SubjectFactory)JavaSourcesSubjectFactory.javaSources()).that(objectList)).processedWith((Processor)processor, new Processor[0]).compilesWithoutError();
        return processor.qualifiedNameMap();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)this.annotationType().getName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (annotations.isEmpty()) {
            return true;
        }
        Set<? extends Element> roundSet = roundEnv.getElementsAnnotatedWith(this.annotationType());
        this.qualifiedNameMap = ElementFilter.typesIn(roundSet).stream().map(this.typeElementMapper()).collect(Collectors.toMap(HasNameInfo::qualifiedName, Function.identity()));
        return true;
    }

    protected abstract Class<? extends Annotation> annotationType();

    protected abstract Function<TypeElement, TypeInfo> typeElementMapper();

    public Stream<TypeElement> typesAnnotatedWith(RoundEnvironment roundEnv) {
        Set<? extends Element> elementSet = roundEnv.getElementsAnnotatedWith(this.annotationType());
        Set<TypeElement> typeSet = ElementFilter.typesIn(elementSet);
        return typeSet.stream();
    }

    Map<String, TypeInfo> qualifiedNameMap() {
        return this.qualifiedNameMap;
    }
}

