/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code;

import br.com.objectos.testing.MoreMatchers;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class JavaPoetAssert {
    private JavaPoetAssert() {
    }

    public static AtAssert at(String dir) {
        return new AtAssert(dir);
    }

    public static class SingleAssert {
        private final String dir;
        private final Object single;

        public SingleAssert(String dir, Object single) {
            this.dir = dir;
            this.single = single;
        }

        public void hasToStringEqualTo(String expected) {
            MatcherAssert.assertThat((Object)this.single, (Matcher)MoreMatchers.toStringEqualTo((String)(this.dir + "/" + expected)));
        }
    }

    public static class OptionalAssert {
        private final String dir;
        private final Optional<?> optional;

        public OptionalAssert(String dir, Optional<?> optional) {
            this.dir = dir;
            this.optional = optional;
        }

        public void hasToStringEqualTo(String expected) {
            MatcherAssert.assertThat((Object)this.optional.isPresent(), (Matcher)MoreMatchers.is((Object)(expected != null ? 1 : 0)));
            if (expected != null) {
                MatcherAssert.assertThat(this.optional.get(), (Matcher)MoreMatchers.toStringEqualTo((String)(this.dir + "/" + expected)));
            }
        }
    }

    public static class ListAssert {
        private final String dir;
        private final List<?> list;

        private ListAssert(String dir, List<?> list) {
            this.dir = dir;
            this.list = list;
        }

        public void hasToStringEqualTo(List<String> expectedList) {
            MatcherAssert.assertThat(this.list, (Matcher)MoreMatchers.hasSize((int)expectedList.size()));
            for (int i = 0; i < this.list.size(); ++i) {
                Object res = this.list.get(i);
                String expected = expectedList.get(i);
                MatcherAssert.assertThat(res, (Matcher)MoreMatchers.toStringEqualTo((String)(this.dir + "/" + expected)));
            }
        }
    }

    public static class AtAssert {
        private final String dir;

        private AtAssert(String dir) {
            this.dir = dir;
        }

        public ListAssert that(List<?> list) {
            return new ListAssert(this.dir, list);
        }

        public OptionalAssert that(Optional<?> optional) {
            return new OptionalAssert(this.dir, optional);
        }

        public SingleAssert that(Object single) {
            return new SingleAssert(this.dir, single);
        }
    }
}

