/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.declaration;

import static br.com.objectos.comuns.lang.Preconditions.checkNotNull;

import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;

public enum AccessLevel {

  PUBLIC,

  DEFAULT,

  PROTECTED,

  PRIVATE;

  public static AccessLevel of(Element element) {
    checkNotNull(element, "element == null");
    return ofModifiersUnchecked(element.getModifiers());
  }

  private static AccessLevel ofModifiersUnchecked(Set<Modifier> modifiers) {
    if (modifiers.contains(Modifier.PUBLIC)) {
      return PUBLIC;
    }

    if (modifiers.contains(Modifier.PROTECTED)) {
      return PROTECTED;
    }

    if (modifiers.contains(Modifier.PRIVATE)) {
      return PRIVATE;
    }

    return DEFAULT;
  }

}