/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.declaration;

import static br.com.objectos.comuns.lang.Preconditions.checkNotNull;

import br.com.objectos.code.java.element.AbstractCodeElement;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.type.ClassName;

class AnnotationMember extends AbstractCodeElement {

  private final String name;
  private final AnnotationValue value;

  AnnotationMember(AnnotatedMemberBuilder builder) {
    name = builder.name;
    value = builder.value;
  }

  @Override
  public final CodeWriter acceptCodeWriter(CodeWriter w) {
    if (name.equals("value")) {
      return acceptJavaWriter0(w);
    } else {
      throw new UnsupportedOperationException("Implement me");
    }
  }

  private CodeWriter acceptJavaWriter0(CodeWriter w) {
    return w.writeCodeElement(value);
  }

  static class AnnotatedMemberBuilder {

    final String name;
    AnnotationValue value = AnnotationValue.empty();

    AnnotatedMemberBuilder(String name) {
      this.name = name;
    }

    public final void addClass(ClassName type) {
      checkNotNull(type);
      value = value.addClass(type);
    }

    public final void addString(String string) {
      checkNotNull(string);
      value = value.addString(string);
    }

    public final AnnotationMember build() {
      return new AnnotationMember(this);
    }

  }

}