/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.declaration;

import br.com.objectos.code.java.element.AbstractCodeElement;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.type.ClassNameOrParameterizedTypeName;
import br.com.objectos.code.java.type.TypeName;

abstract class Extends extends AbstractCodeElement {

  private static final Extends NONE = new None();

  Extends() {}

  public static Extends ofTypeName(ClassNameOrParameterizedTypeName typeName) {
    return typeName.isVoid() ? none() : single(typeName);
  }

  static Extends none() {
    return NONE;
  }

  static Extends single(TypeName name) {
    return new Single(name);
  }

  private static class None extends Extends {
    @Override
    public final CodeWriter acceptCodeWriter(CodeWriter w) {
      return w;
    }
  }

  private static class Single extends Extends {
    private final TypeName name;

    Single(TypeName name) {
      this.name = name;
    }

    @Override
    public final CodeWriter acceptCodeWriter(CodeWriter w) {
      return w.writeWord("extends").writeTypeNameAsWord(name);
    }
  }

}