/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.element;

import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.type.TypeName;

public abstract class AbstractForwardingCodeElement extends AbstractCodeElement {

  private final ImmutableCodeElement delegate;

  protected AbstractForwardingCodeElement(ImmutableCodeElement delegate) {
    this.delegate = delegate;
  }

  protected static CodeElement toCodeElement(TypeName typeName) {
    return CodeElements.ofTypeName(typeName);
  }

  @Override
  public final CodeWriter acceptCodeWriter(CodeWriter w) {
    return w.writeCodeElement(delegate);
  }

  protected final ImmutableCodeElement append(CodeElement element) {
    return delegate.append(element);
  }

  protected static abstract class AbstractBuilder {

    protected final ImmutableCodeElement.Builder builder = ImmutableCodeElement.builder();

    protected AbstractBuilder() {}

    public abstract Object build();

  }

}
