/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.expression;

import br.com.objectos.code.java.element.AbstractForwardingCodeElement;
import br.com.objectos.code.java.element.ImmutableCodeElement;
import br.com.objectos.code.java.statement.VariableInitializer;

final class ArrayInitializerImpl extends AbstractForwardingCodeElement implements ArrayInitializer {

  static final ArrayInitializer EMPTY = new ArrayInitializerImpl(
      ImmutableCodeElement.builder()
          .withWord("{}")
          .build()
  );

  private ArrayInitializerImpl(ImmutableCodeElement delegate) {
    super(delegate);
  }

  static ArrayInitializer a0(VariableInitializer... elements) {
    switch (elements.length) {
      case 0:
        return EMPTY;
      default:
        return new ArrayInitializerImpl(
            ImmutableCodeElement.builder()
                .withOpenBrace()
                .withSpaceOff()
                .withCommaSeparated(elements)
                .withSpaceOff()
                .withCloseBrace()
                .build()
        );
    }
  }

  static ArrayInitializer a0(Iterable<? extends VariableInitializer> elements) {
    return new ArrayInitializerImpl(
        ImmutableCodeElement.builder()
            .withOpenBrace()
            .withSpaceOff()
            .withCommaSeparated(elements)
            .withSpaceOff()
            .withCloseBrace()
            .build()
    );
  }

}
