/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.expression;

import br.com.objectos.code.java.element.AbstractForwardingCodeElement;
import br.com.objectos.code.java.element.ImmutableCodeElement;
import br.com.objectos.code.java.statement.StatementOrBlockBuilder;
import br.com.objectos.code.java.statement.Statements;

final class AssignmentImpl
    // extends AbstractForwarindCodeElement instead of
    // AbstractDefaultCodeElement since AssignmentExpression is on the top of
    // the Expression grammar
    extends AbstractForwardingCodeElement
    implements Assignment {

  private AssignmentImpl(ImmutableCodeElement delegate) {
    super(delegate);
  }

  static Assignment assign0(
      AssignmentOperator operator, LeftHandSide lhs, ExpressionCode rhs) {
    return new AssignmentImpl(
        ImmutableCodeElement.builder()
            .withCodeElement(lhs)
            .withCodeElement(operator)
            .withCodeElement(rhs)
            .build()
    );
  }

  @Override
  public final void acceptStatementOrBlockBuilder(StatementOrBlockBuilder builder) {
    builder.withStatement(this);
  }

  @Override
  public final String toString() {
    return Statements.toString(this);
  }

}
