/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.expression;

import br.com.objectos.code.java.element.CodeElement;
import br.com.objectos.code.java.io.CodeWriter;

public enum AssignmentOperator implements CodeElement {

  SIMPLE("="),

  MULTIPLICATION("*="),

  DIVISION("/="),

  REMAINDER("%="),

  ADDITION("+="),

  SUBTRACTION("-="),

  LEFT_SHIFT("<<="),

  RIGHT_SHIFT(">>="),

  UNSIGNED_RIGHT_SHIFT(">>>="),

  BITWISE_AND("&="),

  BITWISE_XOR("^="),

  BITWISE_OR("|=");

  private final String word;

  private AssignmentOperator(String word) {
    this.word = word;
  }

  @Override
  public final CodeWriter acceptCodeWriter(CodeWriter w) {
    return w.writeWord(word);
  }

  @Override
  public final String toString() {
    return acceptCodeWriter(CodeWriter.forToString()).toString();
  }

}