/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.expression;

import br.com.objectos.code.java.element.CodeElement;

public interface Callee extends CodeElement {

  MethodInvocation invoke(String methodName);

  MethodInvocation invoke(String methodName, Argument a1);

  MethodInvocation invoke(String methodName, Argument a1, Argument a2);

  MethodInvocation invoke(String methodName, Argument a1, Argument a2, Argument a3);

  MethodInvocation invoke(String methodName, Argument a1, Argument a2, Argument a3, Argument a4);

  MethodInvocation invoke(String methodName, Iterable<? extends Argument> args);

  MethodInvocation invoke(
      TypeWitness witness, String methodName);

  MethodInvocation invoke(
      TypeWitness witness, String methodName,
      Argument a1);

  MethodInvocation invoke(
      TypeWitness witness, String methodName,
      Argument a1, Argument a2);

  MethodInvocation invoke(
      TypeWitness witness, String methodName,
      Argument a1, Argument a2, Argument a3);

  MethodInvocation invoke(
      TypeWitness witness, String methodName,
      Argument a1, Argument a2, Argument a3, Argument a4);

  MethodInvocation invoke(
      TypeWitness witness, String methodName,
      Iterable<? extends Argument> args);

}