/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.io;

import br.com.objectos.code.java.declaration.PackageName;
import br.com.objectos.code.java.type.ClassName;
import br.com.objectos.code.java.type.TypeName;

public abstract class ImportSet {

  private static final ImportSet FOR_TO_STRING = new ForToStringImportSet();

  ImportSet() {}

  public static ImportSet forPackageName(PackageName packageName) {
    return new JavaFileImportSet(packageName);
  }

  static ImportSet forToString() {
    return FOR_TO_STRING;
  }

  public abstract boolean contains(ClassName qualifiedName);

  public abstract String get(TypeName typeName);

  public abstract boolean isEmpty();

  public abstract int size();

  private static class ForToStringImportSet extends ImportSet {
    @Override
    public final boolean contains(ClassName qualifiedName) {
      return false;
    }

    @Override
    public final String get(TypeName typeName) {
      return typeName.toString();
    }

    @Override
    public final boolean isEmpty() {
      return true;
    }

    @Override
    public final int size() {
      return 0;
    }
  }

}