/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.io;

import br.com.objectos.code.java.declaration.BodyElement;
import br.com.objectos.comuns.collections.StreamIterable;

class TailFormattingAction extends FormattingAction {

  private TailFormattingAction() {
    super(new NoopFormattingAction());
  }

  static TailFormattingAction getInstance() {
    return new TailFormattingAction();
  }

  @Override
  public final void consume(FormattingSource source) {
    while (source.hasElements()) {
      consumeElement(source.getElement());
    }
  }

  @Override
  public final void consumeElement(BodyElement element) {
    storeElement(element);
  }

  private static class NoopFormattingAction extends FormattingAction {

    private NoopFormattingAction() {
      super(null);
    }

    @Override
    public final void consume(FormattingSource source) {
      throw new UnsupportedOperationException();
    }

    @Override
    public final void consumeElement(BodyElement element) {
      throw new UnsupportedOperationException();
    }

    @Override
    public final StreamIterable<BodyElement> stream() {
      return StreamIterable.empty();
    }

  }

}