/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.statement;

import static br.com.objectos.comuns.lang.Preconditions.checkNotNull;

import br.com.objectos.code.java.element.AbstractCodeElement;
import br.com.objectos.code.java.expression.Identifier;
import br.com.objectos.code.java.type.ClassName;
import br.com.objectos.code.java.type.TypeName;
import br.com.objectos.comuns.collections.ImmutableList;

abstract class TryElement extends AbstractCodeElement {

  public final TryCatchStatement.Builder _catch(Class<? extends Throwable> type, Identifier id) {
    checkNotNull(type, "type == null");
    checkNotNull(id, "id == null");
    return _catch0(id, toTypeName(type));
  }

  public final TryCatchStatement.Builder _catch(
      Class<? extends Throwable> type1,
      Class<? extends Throwable> type2,
      Identifier id) {
    checkNotNull(type1, "type1 == null");
    checkNotNull(type2, "type2 == null");
    checkNotNull(id, "id == null");
    return _catch0(id, toTypeName(type1), toTypeName(type2));
  }

  private TryCatchStatement.Builder _catch0(Identifier id, TypeName... types) {
    ImmutableList<TypeName> exceptionTypes = ImmutableList.newListWithAll(types);
    return TryCatchStatement.builder(this, exceptionTypes, id);
  }

  private TypeName toTypeName(Class<? extends Throwable> type) {
    return ClassName.of(type);
  }

}
