/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.type;

import static br.com.objectos.comuns.lang.Preconditions.checkNotNull;

import java.util.Iterator;

public interface ClassNameOrParameterizedTypeName extends ReferenceTypeName {

  static ClassNameOrParameterizedTypeName noType() {
    return NoTypeName._void();
  }

  default ArrayTypeName toArrayTypeName() {
    return ArrayTypeName.ofUnchecked(this);
  }

  default ParameterizedTypeName withTypeArgument(Class<?> type) {
    return withTypeArgument(ClassName.of(type));
  }

  default ParameterizedTypeName withTypeArgument(String name) {
    return withTypeArgument(TypeVariableName.named(name));
  }

  ParameterizedTypeName withTypeArgument(TypeName type);

  default ClassNameOrParameterizedTypeName withTypeArguments(
      Iterable<? extends TypeName> arguments) {
    checkNotNull(arguments, "arguments == null");
    return withTypeArguments(arguments.iterator());
  }

  default ClassNameOrParameterizedTypeName withTypeArguments(
      Iterator<? extends TypeName> arguments) {
    checkNotNull(arguments, "arguments == null");
    if (arguments.hasNext()) {
      ParameterizedTypeName result = withTypeArgument(arguments.next());
      while (arguments.hasNext()) {
        result = result.withTypeArgument(arguments.next());
      }
      return result;
    } else {
      return this;
    }
  }

}