/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.declaration;

import br.com.objectos.code.java.declaration.BodyElement;
import br.com.objectos.code.java.declaration.ClassBodyElement;
import br.com.objectos.code.java.declaration.ConstructorCodeElement;
import br.com.objectos.code.java.declaration.ParameterCode;
import br.com.objectos.code.java.element.AbstractCodeElement;
import br.com.objectos.code.java.element.CodeElement;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.statement.Block;
import br.com.objectos.code.java.statement.BlockStatement;
import br.com.objectos.code.java.type.ClassName;
import br.com.objectos.code.java.type.TypeName;
import br.com.objectos.comuns.collections.GrowableList;
import br.com.objectos.comuns.collections.ImmutableList;
import br.com.objectos.comuns.collections.ImmutableSet;
import br.com.objectos.comuns.lang.Preconditions;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;

public final class ConstructorCode
extends AbstractCodeElement
implements ClassBodyElement {
    private static final ConstructorCode PRIVATE = ConstructorCode._private().build();
    private final ImmutableSet<Modifier> modifierSet;
    private final ImmutableList<ParameterCode> parameters;
    private final Block block;

    ConstructorCode(Builder builder) {
        this.modifierSet = builder.modifierSet();
        this.parameters = builder.parameters();
        this.block = builder.block();
    }

    public static Builder _private() {
        return ConstructorCode.builder()._private();
    }

    public static Builder _protected() {
        return ConstructorCode.builder()._protected();
    }

    public static Builder _public() {
        return ConstructorCode.builder()._public();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ConstructorCode privateConstructor() {
        return PRIVATE;
    }

    public static Builder withSignature(ConstructorCodeElement element) {
        return ConstructorCode.builder().withSignature(element);
    }

    public static Builder withSignature(ExecutableElement element) {
        return ConstructorCode.builder().withSignature(element);
    }

    @Override
    public final CodeWriter acceptCodeWriter(CodeWriter w) {
        return w.writeModifierSet((Iterable<Modifier>)this.modifierSet).writeSimpleName().writeParameters((Iterable<? extends CodeElement>)this.parameters).writeCodeElement(this.block);
    }

    @Override
    public final BodyElement.Kind kind() {
        return BodyElement.Kind.CONSTRUCTOR;
    }

    @Override
    public final String toString() {
        return this.acceptCodeWriter(CodeWriter.forToString().pushSimpleName("Constructor")).popSimpleName().toString();
    }

    public static class Builder {
        private Modifier accessModifier;
        private final GrowableList<ParameterCode> parameters = GrowableList.newList();
        private final GrowableList<BlockStatement> body = GrowableList.newList();

        private Builder() {
        }

        public final ConstructorCode build() {
            return new ConstructorCode(this);
        }

        public final Builder _private() {
            return this.setAccessModifier(Modifier.PRIVATE);
        }

        public final Builder _protected() {
            return this.setAccessModifier(Modifier.PROTECTED);
        }

        public final Builder _public() {
            return this.setAccessModifier(Modifier.PUBLIC);
        }

        public final Builder body(BlockStatement ... statements) {
            this.body.fluentAdd((Object[])statements);
            return this;
        }

        public final Builder body(Iterable<? extends BlockStatement> statements) {
            this.body.fluentAddAll(statements);
            return this;
        }

        public final Builder withParameter(Class<?> type, String name) {
            Preconditions.checkNotNull(type, (String)"type == null");
            Preconditions.checkNotNull((Object)name, (String)"name == null");
            ClassName typeName = ClassName.ofUnchecked(type);
            ParameterCode parameter = ParameterCode.ofUnchecked(typeName, name);
            return this.withParameterUnchecked(parameter);
        }

        public final Builder withParameter(ParameterCode parameter) {
            Preconditions.checkNotNull((Object)parameter, (String)"parameter == null");
            return this.withParameterUnchecked(parameter);
        }

        public final Builder withParameter(TypeName typeName, String name) {
            Preconditions.checkNotNull((Object)typeName, (String)"typeName == null");
            Preconditions.checkNotNull((Object)name, (String)"name == null");
            ParameterCode parameter = ParameterCode.ofUnchecked(typeName, name);
            return this.withParameterUnchecked(parameter);
        }

        public final Builder withParameters(Iterable<ParameterCode> parameters) {
            Preconditions.checkNotNull(parameters, (String)"parameters == null");
            for (ParameterCode parameter : parameters) {
                this.withParameter(parameter);
            }
            return this;
        }

        public final Builder withParametersFrom(ConstructorCodeElement element) {
            for (ParameterCode parameter : element.parametersStream(ParameterCode::of)) {
                this.withParameter(parameter);
            }
            return this;
        }

        public final Builder withSignature(ConstructorCodeElement element) {
            Preconditions.checkNotNull((Object)element, (String)"element == null");
            return this.withAccessModifier(element).withParametersFrom(element);
        }

        public final Builder withSignature(ExecutableElement element) {
            Preconditions.checkNotNull((Object)element, (String)"element == null");
            return this.withAccessModifier(element).withParameterList(element);
        }

        final Block block() {
            return Block.of(this.body);
        }

        final ImmutableSet<Modifier> modifierSet() {
            return this.accessModifier != null ? ImmutableSet.newSetWith((Object)((Object)this.accessModifier)) : ImmutableSet.empty();
        }

        final ImmutableList<ParameterCode> parameters() {
            return this.parameters.toImmutableList();
        }

        private Builder setAccessModifier(Modifier modifier) {
            this.accessModifier = modifier;
            return this;
        }

        private Builder withAccessModifier(ConstructorCodeElement element) {
            if (element.isPublic()) {
                return this._public();
            }
            if (element.isProtected()) {
                return this._protected();
            }
            if (element.isPrivate()) {
                return this._private();
            }
            return this;
        }

        private Builder withAccessModifier(ExecutableElement element) {
            Set<Modifier> modifiers = element.getModifiers();
            if (modifiers.contains((Object)Modifier.PUBLIC)) {
                return this._public();
            }
            if (modifiers.contains((Object)Modifier.PROTECTED)) {
                return this._protected();
            }
            if (modifiers.contains((Object)Modifier.PRIVATE)) {
                return this._private();
            }
            return this;
        }

        private Builder withParameterUnchecked(ParameterCode parameter) {
            this.parameters.add((Object)parameter);
            return this;
        }

        private Builder withParameterList(ExecutableElement element) {
            List<? extends VariableElement> parameters = element.getParameters();
            for (VariableElement variableElement : parameters) {
                this.withParameterUnchecked(ParameterCode.of(variableElement));
            }
            return this;
        }
    }
}

