/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.element;

import br.com.objectos.code.java.element.AbstractCodeElement;
import br.com.objectos.code.java.element.CodeElement;
import br.com.objectos.code.java.element.CodeElements;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.type.TypeName;
import br.com.objectos.comuns.collections.GrowableList;
import br.com.objectos.comuns.collections.ImmutableList;
import br.com.objectos.comuns.lang.Preconditions;
import java.util.Iterator;

public abstract class AbstractImmutableCodeElement
extends AbstractCodeElement {
    private final ImmutableList<CodeElement> elements;

    protected AbstractImmutableCodeElement(ImmutableList<CodeElement> elements) {
        this.elements = elements;
    }

    @Override
    public final CodeWriter acceptCodeWriter(CodeWriter w) {
        return w.writeCodeElements((Iterable<? extends CodeElement>)this.elements);
    }

    protected static abstract class AbstractBuilder<SELF extends AbstractBuilder<SELF>> {
        private final GrowableList<CodeElement> els = GrowableList.newList();

        protected AbstractBuilder() {
        }

        public abstract Object build();

        public final SELF with(String string) {
            Preconditions.checkNotNull((Object)string, (String)"string == null");
            return this.withCodeElement(CodeElements.ofRaw(string));
        }

        public final SELF withCloseBrace() {
            return this.withCodeElement(CodeElements.CLOSE_BRACE);
        }

        public final SELF withCloseBracket() {
            return this.withCodeElement(CodeElements.CLOSE_BRACKET);
        }

        public final SELF withCodeElement(CodeElement element) {
            this.els.addWithNullMessage((Object)element, "element == null");
            return this.self();
        }

        public final SELF withCommaSeparated(CodeElement ... elements) {
            return this.withCommaSeparated((Iterable<CodeElement>)ImmutableList.newListWithAll((Object[])elements));
        }

        public final SELF withCommaSeparated(Iterable<? extends CodeElement> elements) {
            Preconditions.checkNotNull(elements, (String)"elements == null");
            Iterator<? extends CodeElement> it = elements.iterator();
            if (it.hasNext()) {
                this.els.add((Object)it.next());
                while (it.hasNext()) {
                    this.els.add((Object)CodeElements.COMMA);
                    this.els.add((Object)it.next());
                }
            }
            return this.self();
        }

        public final SELF withDot() {
            return this.withCodeElement(CodeElements.DOT);
        }

        public final SELF withIndentIfNecessary() {
            return this.withCodeElement(CodeElements.INDENT_IF_NECESSARY);
        }

        public final SELF withOpenBrace() {
            return this.withCodeElement(CodeElements.OPEN_BRACE);
        }

        public final SELF withOpenBracket() {
            return this.withCodeElement(CodeElements.OPEN_BRACKET);
        }

        public final SELF withSpaceOff() {
            return this.withCodeElement(CodeElements.SPACE_OFF);
        }

        public final SELF withTypeName(TypeName typeName) {
            return this.withCodeElement(CodeElements.ofTypeName(typeName));
        }

        public final SELF withWord(String word) {
            Preconditions.checkNotNull((Object)word, (String)"word == null");
            return this.withCodeElement(CodeElements.ofWord(word));
        }

        protected abstract SELF self();

        protected final ImmutableList<CodeElement> elements() {
            return this.els.toImmutableList();
        }
    }
}

