/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.declaration;

import br.com.objectos.comuns.collections.ImmutableSet;
import javax.lang.model.element.Modifier;

public final class ClassModifier extends ElementModifier {

  private static final ClassModifier EMPTY = new ClassModifier(ImmutableSet.empty());

  private ClassModifier(Builder builder) {
    super(builder);
  }

  private ClassModifier(ImmutableSet<Modifier> values) {
    super(values);
  }

  public static Builder _abstract() {
    return builder()._abstract();
  }

  public static Builder _final() {
    return builder()._final();
  }

  public static Builder _private() {
    return builder()._private();
  }

  public static Builder _protected() {
    return builder()._protected();
  }

  public static Builder _public() {
    return builder()._public();
  }

  public static Builder _static() {
    return builder()._static();
  }

  public static Builder builder() {
    return new Builder();
  }

  public static ClassModifier empty() {
    return EMPTY;
  }

  public static final class Builder extends ElementModifier.Builder<ClassModifier> {

    private Builder() {}

    public final Builder _abstract() {
      return with(Modifier.ABSTRACT);
    }

    public final Builder _final() {
      return with(Modifier.FINAL);
    }

    public final Builder _private() {
      return with(Modifier.PRIVATE);
    }

    public final Builder _protected() {
      return with(Modifier.PROTECTED);
    }

    public final Builder _public() {
      return with(Modifier.PUBLIC);
    }

    public final Builder _static() {
      return with(Modifier.STATIC);
    }

    @Override
    public final ClassModifier build() {
      return new ClassModifier(this);
    }

    private Builder with(Modifier modifier) {
      withModifier(modifier);
      return this;
    }

  }

}