/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.element;

import br.com.objectos.code.java.expression.AdditiveExpression;
import br.com.objectos.code.java.expression.Argument;
import br.com.objectos.code.java.expression.ArrayAccess;
import br.com.objectos.code.java.expression.ArrayReferenceExpression;
import br.com.objectos.code.java.expression.Assignment;
import br.com.objectos.code.java.expression.AssignmentOperator;
import br.com.objectos.code.java.expression.Callee;
import br.com.objectos.code.java.expression.ConditionalAndExpression;
import br.com.objectos.code.java.expression.ConditionalExpression;
import br.com.objectos.code.java.expression.ConditionalOrExpression;
import br.com.objectos.code.java.expression.EqualityExpression;
import br.com.objectos.code.java.expression.ExpressionCode;
import br.com.objectos.code.java.expression.Expressions;
import br.com.objectos.code.java.expression.InclusiveOrExpression;
import br.com.objectos.code.java.expression.LambdaExpression;
import br.com.objectos.code.java.expression.LeftHandSide;
import br.com.objectos.code.java.expression.MethodInvocation;
import br.com.objectos.code.java.expression.MethodReference;
import br.com.objectos.code.java.expression.MethodReferenceReferenceExpression;
import br.com.objectos.code.java.expression.MultiplicativeExpression;
import br.com.objectos.code.java.expression.PostDecrementExpression;
import br.com.objectos.code.java.expression.PostIncrementExpression;
import br.com.objectos.code.java.expression.PostfixExpression;
import br.com.objectos.code.java.expression.RelationalExpression;
import br.com.objectos.code.java.expression.ShiftExpression;
import br.com.objectos.code.java.expression.TypeWitness;
import br.com.objectos.code.java.expression.UnaryExpression;
import br.com.objectos.code.java.type.ReferenceTypeName;

public abstract class AbstractDefaultCodeElement extends AbstractForwardingCodeElement {

  protected AbstractDefaultCodeElement(ImmutableCodeElement delegate) {
    super(delegate);
  }

  // AdditiveExpression

  public final AdditiveExpression add(MultiplicativeExpression rhs) {
    return Expressions.add(selfAdditiveExpression(), rhs);
  }

  public final AdditiveExpression subtract(MultiplicativeExpression rhs) {
    return Expressions.subtract(selfAdditiveExpression(), rhs);
  }

  protected AdditiveExpression selfAdditiveExpression() {
    return selfMultiplicativeExpression();
  }

  // ArrayAccess

  public final ArrayAccess aget(ExpressionCode e0) {
    return Expressions.aget(selfArrayReferenceExpression(), e0);
  }

  public final ArrayAccess aget(ExpressionCode e0, ExpressionCode e1) {
    return Expressions.aget(selfArrayReferenceExpression(), e0, e1);
  }

  public final ArrayAccess aget(ExpressionCode e0, ExpressionCode e1, ExpressionCode e2) {
    return Expressions.aget(selfArrayReferenceExpression(), e0, e1, e2);
  }

  public final ArrayAccess aget(
      ExpressionCode e0, ExpressionCode e1, ExpressionCode e2, ExpressionCode e3) {
    return Expressions.aget(selfArrayReferenceExpression(), e0, e1, e2, e3);
  }

  public final ArrayAccess aget(Iterable<? extends ExpressionCode> expressions) {
    return Expressions.aget(selfArrayReferenceExpression(), expressions);
  }

  public final ArrayAccess arrayAccess(ExpressionCode e0) {
    return Expressions.arrayAccess(selfArrayReferenceExpression(), e0);
  }

  public final ArrayAccess arrayAccess(ExpressionCode e0, ExpressionCode e1) {
    return Expressions.arrayAccess(selfArrayReferenceExpression(), e0, e1);
  }

  public final ArrayAccess arrayAccess(ExpressionCode e0, ExpressionCode e1,
      ExpressionCode e2) {
    return Expressions.arrayAccess(selfArrayReferenceExpression(), e0, e1, e2);
  }

  public final ArrayAccess arrayAccess(
      ExpressionCode e0, ExpressionCode e1, ExpressionCode e2, ExpressionCode e3) {
    return Expressions.arrayAccess(selfArrayReferenceExpression(), e0, e1, e2, e3);
  }

  public final ArrayAccess arrayAccess(Iterable<? extends ExpressionCode> expressions) {
    return Expressions.arrayAccess(selfArrayReferenceExpression(), expressions);
  }

  protected abstract ArrayReferenceExpression selfArrayReferenceExpression();

  // Assigment

  public final Assignment receive(ExpressionCode expression) {
    return Expressions.assign(selfLeftHandSide(), expression);
  }

  public final Assignment receive(AssignmentOperator operator, ExpressionCode expression) {
    return Expressions.assign(operator, selfLeftHandSide(), expression);
  }

  protected abstract LeftHandSide selfLeftHandSide();

  // ConditionalAndExpression

  public final ConditionalAndExpression and(InclusiveOrExpression rhs) {
    return Expressions.and(selfConditionalAndExpression(), rhs);
  }

  protected abstract ConditionalAndExpression selfConditionalAndExpression();

  // ConditionalExpression

  public final ConditionalExpression ternary(
      ExpressionCode trueExpression, ConditionalExpression falseExpression) {
    return Expressions.ternary(selfConditionalOrExpression(), trueExpression, falseExpression);
  }

  public final ConditionalExpression ternary(
      ExpressionCode trueExpression, LambdaExpression falseExpression) {
    return Expressions.ternary(selfConditionalOrExpression(), trueExpression, falseExpression);
  }

  // ConditionalOrExpression

  public final ConditionalOrExpression or(ConditionalAndExpression expression) {
    return Expressions.or(selfConditionalOrExpression(), expression);
  }

  protected ConditionalOrExpression selfConditionalOrExpression() {
    return selfConditionalAndExpression();
  }

  // EqualityExpression

  public final EqualityExpression eq(RelationalExpression rhs) {
    return Expressions.eq(selfEqualityExpression(), rhs);
  }

  public final EqualityExpression ne(RelationalExpression rhs) {
    return Expressions.ne(selfEqualityExpression(), rhs);
  }

  protected final EqualityExpression selfEqualityExpression() {
    return selfRelationalExpression();
  }

  // MethodInvocationExpression

  public final MethodInvocation invoke(String methodName) {
    return Expressions.invoke(selfCallee(), methodName);
  }

  public final MethodInvocation invoke(String methodName, Argument a1) {
    return Expressions.invoke(selfCallee(), methodName, a1);
  }

  public final MethodInvocation invoke(String methodName, Argument a1, Argument a2) {
    return Expressions.invoke(selfCallee(), methodName, a1, a2);
  }

  public final MethodInvocation invoke(String methodName, Argument a1, Argument a2, Argument a3) {
    return Expressions.invoke(selfCallee(), methodName, a1, a2, a3);
  }

  public final MethodInvocation invoke(
      String methodName, Argument a1, Argument a2, Argument a3, Argument a4) {
    return Expressions.invoke(selfCallee(), methodName, a1, a2, a3, a4);
  }

  public final MethodInvocation invoke(String methodName, Iterable<? extends Argument> args) {
    return Expressions.invoke(selfCallee(), methodName, args);
  }

  public final MethodInvocation invoke(
      TypeWitness witness, String methodName) {
    return Expressions.invoke(selfCallee(), witness, methodName);
  }

  public final MethodInvocation invoke(
      TypeWitness witness, String methodName, Argument a1) {
    return Expressions.invoke(selfCallee(), witness, methodName, a1);
  }

  public final MethodInvocation invoke(
      TypeWitness witness, String methodName, Argument a1, Argument a2) {
    return Expressions.invoke(selfCallee(), witness, methodName, a1, a2);
  }

  public final MethodInvocation invoke(
      TypeWitness witness, String methodName, Argument a1, Argument a2, Argument a3) {
    return Expressions.invoke(selfCallee(), witness, methodName, a1, a2, a3);
  }

  public final MethodInvocation invoke(
      TypeWitness witness, String methodName, Argument a1, Argument a2, Argument a3, Argument a4) {
    return Expressions.invoke(selfCallee(), witness, methodName, a1, a2, a3, a4);
  }

  public final MethodInvocation invoke(
      TypeWitness witness, String methodName, Iterable<? extends Argument> args) {
    return Expressions.invoke(selfCallee(), witness, methodName, args);
  }

  protected abstract Callee selfCallee();

  // MethodReference

  public final MethodReference ref(String methodName) {
    return Expressions.ref(selfMethodReferenceReferenceExpression(), methodName);
  }

  public final MethodReference ref(TypeWitness witness, String methodName) {
    return Expressions.ref(selfMethodReferenceReferenceExpression(), witness, methodName);
  }

  protected abstract MethodReferenceReferenceExpression selfMethodReferenceReferenceExpression();

  // MultiplicativeExpression

  public final MultiplicativeExpression divide(UnaryExpression rhs) {
    return Expressions.divide(selfMultiplicativeExpression(), rhs);
  }

  public final MultiplicativeExpression multiply(UnaryExpression rhs) {
    return Expressions.multiply(selfMultiplicativeExpression(), rhs);
  }

  public final MultiplicativeExpression remainder(UnaryExpression rhs) {
    return Expressions.remainder(selfMultiplicativeExpression(), rhs);
  }

  protected abstract MultiplicativeExpression selfMultiplicativeExpression();

  // PostDecrementExpression

  public final PostDecrementExpression postDec() {
    return Expressions.postDec(selfPostfixExpression());
  }

  public final PostIncrementExpression postInc() {
    return Expressions.postInc(selfPostfixExpression());
  }

  protected abstract PostfixExpression selfPostfixExpression();

  // RelationalExpression

  public final RelationalExpression lt(ShiftExpression rhs) {
    return Expressions.lt(selfRelationalExpression(), rhs);
  }

  public final RelationalExpression gt(ShiftExpression rhs) {
    return Expressions.gt(selfRelationalExpression(), rhs);
  }

  public final RelationalExpression le(ShiftExpression rhs) {
    return Expressions.le(selfRelationalExpression(), rhs);
  }

  public final RelationalExpression ge(ShiftExpression rhs) {
    return Expressions.ge(selfRelationalExpression(), rhs);
  }

  public final RelationalExpression instanceOf(ReferenceTypeName typeName) {
    return Expressions.instanceOf(selfRelationalExpression(), typeName);
  }

  protected abstract RelationalExpression selfRelationalExpression();

  // ShiftExpression

  public final ShiftExpression leftShift(AdditiveExpression expression) {
    return Expressions.leftShift(selfShiftExpression(), expression);
  }

  public final ShiftExpression rightShift(AdditiveExpression expression) {
    return Expressions.rightShift(selfShiftExpression(), expression);
  }

  public final ShiftExpression unsignedRightShift(AdditiveExpression expression) {
    return Expressions.unsignedRightShift(selfShiftExpression(), expression);
  }

  protected ShiftExpression selfShiftExpression() {
    return selfAdditiveExpression();
  }

  protected UnsupportedOperationException newUoe(Class<?> typeName) {
    return new UnsupportedOperationException("Not supported for " + typeName.getSimpleName());
  }

}
