/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.expression;

import br.com.objectos.code.java.element.AbstractDefaultCodeElement;
import br.com.objectos.code.java.element.ImmutableCodeElement;

final class IdentifierImpl extends AbstractDefaultCodeElement implements Identifier {

  private final String name;

  private IdentifierImpl(ImmutableCodeElement delegate, String name) {
    super(delegate);
    this.name = name;
  }

  static Identifier id0(String name) {
    return new IdentifierImpl(
        ImmutableCodeElement.builder()
            .withWord(name)
            .build(),
        name
    );
  }

  @Override
  public final ExpressionName id(Identifier id) {
    return Expressions.expressionName(this, id);
  }

  @Override
  public final ExpressionName id(String id) {
    return Expressions.expressionName(this, id);
  }

  @Override
  public final String name() {
    return name;
  }

  @Override
  protected final ArrayReferenceExpression selfArrayReferenceExpression() {
    return this;
  }

  @Override
  protected final Callee selfCallee() {
    return this;
  }

  @Override
  protected final ConditionalAndExpression selfConditionalAndExpression() {
    return this;
  }

  @Override
  protected final LeftHandSide selfLeftHandSide() {
    return this;
  }

  @Override
  protected final MethodReferenceReferenceExpression selfMethodReferenceReferenceExpression() {
    return this;
  }

  @Override
  protected final MultiplicativeExpression selfMultiplicativeExpression() {
    return this;
  }

  @Override
  protected final PostfixExpression selfPostfixExpression() {
    return this;
  }

  @Override
  protected final RelationalExpression selfRelationalExpression() {
    return this;
  }

}
