/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.expression;

import br.com.objectos.code.java.element.AbstractForwardingCodeElement;
import br.com.objectos.code.java.element.ImmutableCodeElement;

final class LambdaExpressionImpl
    extends AbstractForwardingCodeElement
    implements LambdaExpression {

  private LambdaExpressionImpl(ImmutableCodeElement delegate) {
    super(delegate);
  }

  static LambdaExpression lambda0(
      LambdaBody body) {
    return lambda1(body, Arguments.empty());
  }

  static LambdaExpression lambda0(
      LambdaBody body, Identifier single) {
    return new LambdaExpressionImpl(
        ImmutableCodeElement.builder()
            .withCodeElement(single)
            .withWord("->")
            .withCodeElement(body)
            .build()
    );
  }

  static LambdaExpression lambda0(
      LambdaBody body, LambdaParameter... params) {
    return lambda1(body, Arguments.of(params));
  }

  static LambdaExpression lambda0(
      LambdaBody body, Iterable<? extends LambdaParameter> params) {
    return lambda1(body, Arguments.of(params));
  }

  static LambdaExpression lambda1(
      LambdaBody body, Arguments args) {
    return new LambdaExpressionImpl(
        ImmutableCodeElement.builder()
            .withCodeElement(args)
            .withWord("->")
            .withCodeElement(body)
            .build()
    );
  }

}
