/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.expression;

import br.com.objectos.code.java.element.ImmutableCodeElement;
import br.com.objectos.code.java.element.NewLine;

final class MethodInvocationImpl
    extends AbstractDefaultStatementExpression
    implements
    MethodInvocation {

  private MethodInvocationImpl(ImmutableCodeElement delegate) {
    super(delegate);
  }

  static MethodInvocation invoke0(
      Callee callee, String methodName) {
    return invoke1(callee, methodName, Arguments.empty());
  }

  static MethodInvocation invoke0(
      Callee callee, String methodName, Argument... args) {
    return invoke1(callee, methodName, Arguments.of(args));
  }

  static MethodInvocation invoke0(
      Callee callee, String methodName, Iterable<? extends Argument> args) {
    return invoke1(callee, methodName, Arguments.of(args));
  }

  static MethodInvocation invoke0(
      Callee callee, TypeWitness witness, String methodName) {
    return invoke1(callee, witness, methodName, Arguments.empty());
  }

  static MethodInvocation invoke0(
      Callee callee, TypeWitness witness, String methodName, Argument... args) {
    return invoke1(callee, witness, methodName, Arguments.of(args));
  }

  static MethodInvocation invoke0(
      Callee callee, TypeWitness witness, String methodName, Iterable<? extends Argument> args) {
    return invoke1(callee, witness, methodName, Arguments.of(args));
  }

  static MethodInvocation invoke0(String methodName) {
    return invoke1(methodName, Arguments.empty());
  }

  static MethodInvocation invoke0(String methodName, Argument... args) {
    return invoke1(methodName, Arguments.of(args));
  }

  static MethodInvocation invoke0(String methodName, Iterable<? extends Argument> args) {
    return invoke1(methodName, Arguments.of(args));
  }

  private static MethodInvocation build0(ImmutableCodeElement delegate) {
    return new MethodInvocationImpl(delegate);
  }

  private static MethodInvocation invoke1(Callee callee, String methodName, Arguments args) {
    return build0(
        ImmutableCodeElement.builder()
            .withCodeElement(callee)
            .withIndentIfNecessary()
            .withSpaceOff()
            .withDot()
            .with(methodName)
            .withSpaceOff()
            .withCodeElement(args)
            .build()
    );
  }

  private static MethodInvocation invoke1(
      Callee callee, TypeWitness witness, String methodName, Arguments args) {
    return build0(
        ImmutableCodeElement.builder()
            .withCodeElement(callee)
            .withIndentIfNecessary()
            .withSpaceOff()
            .withDot()
            .withSpaceOff()
            .withCodeElement(witness)
            .withWord(methodName)
            .withSpaceOff()
            .withCodeElement(args)
            .build()
    );
  }

  static MethodInvocation invoke1(String methodName, Arguments args) {
    return build0(
        ImmutableCodeElement.builder()
            .withIndentIfNecessary()
            .withWord(methodName)
            .withSpaceOff()
            .withCodeElement(args)
            .build()
    );
  }

  @Override
  public final MethodInvocation nl() {
    return build0(append(NewLine.nextLine()));
  }

  @Override
  public final FieldAccess id(Identifier id) {
    return Expressions.fieldAccess(this, id);
  }

  @Override
  public final FieldAccess id(String id) {
    return Expressions.fieldAccess(this, id);
  }

  @Override
  protected final ArrayReferenceExpression selfArrayReferenceExpression() {
    return this;
  }

  @Override
  protected final Callee selfCallee() {
    return this;
  }

  @Override
  protected final ConditionalAndExpression selfConditionalAndExpression() {
    return this;
  }

  @Override
  protected final LeftHandSide selfLeftHandSide() {
    throw newUoe(MethodInvocation.class);
  }

  @Override
  protected final MethodReferenceReferenceExpression selfMethodReferenceReferenceExpression() {
    return this;
  }

  @Override
  protected final MultiplicativeExpression selfMultiplicativeExpression() {
    return this;
  }

  @Override
  protected final PostfixExpression selfPostfixExpression() {
    return this;
  }

  @Override
  protected final RelationalExpression selfRelationalExpression() {
    return this;
  }

}
