/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.expression;

import br.com.objectos.code.java.element.AbstractDefaultCodeElement;
import br.com.objectos.code.java.element.ImmutableCodeElement;
import br.com.objectos.code.java.type.ReferenceTypeName;

final class MethodReferenceImpl
    extends AbstractDefaultCodeElement
    implements MethodReference {

  private MethodReferenceImpl(ImmutableCodeElement delegate) {
    super(delegate);
  }

  static MethodReference ref0(
      MethodReferenceReferenceExpression expression, String methodName) {
    return new MethodReferenceImpl(
        ImmutableCodeElement.builder()
            .withCodeElement(expression)
            .with("::")
            .withSpaceOff()
            .withWord(methodName)
            .build()
    );
  }

  static MethodReference ref0(
      MethodReferenceReferenceExpression expression, TypeWitness witness, String methodName) {
    return new MethodReferenceImpl(
        ImmutableCodeElement.builder()
            .withCodeElement(expression)
            .with("::")
            .withSpaceOff()
            .withCodeElement(witness)
            .withWord(methodName)
            .build()
    );
  }

  static MethodReference ref0(
      ReferenceTypeName typeName, String methodName) {
    return new MethodReferenceImpl(
        ImmutableCodeElement.builder()
            .withTypeName(typeName)
            .with("::")
            .withSpaceOff()
            .withWord(methodName)
            .build()
    );
  }

  static MethodReference ref0(
      ReferenceTypeName typeName, TypeWitness witness, String methodName) {
    return new MethodReferenceImpl(
        ImmutableCodeElement.builder()
            .withTypeName(typeName)
            .with("::")
            .withSpaceOff()
            .withCodeElement(witness)
            .withWord(methodName)
            .build()
    );
  }

  @Override
  public final FieldAccess id(Identifier id) {
    return Expressions.fieldAccess(this, id);
  }

  @Override
  public final FieldAccess id(String id) {
    return Expressions.fieldAccess(this, id);
  }

  @Override
  protected final ArrayReferenceExpression selfArrayReferenceExpression() {
    throw newUoe(MethodReference.class);
  }

  @Override
  protected final ConditionalAndExpression selfConditionalAndExpression() {
    return this;
  }

  @Override
  protected final Callee selfCallee() {
    return this;
  }

  @Override
  protected final LeftHandSide selfLeftHandSide() {
    throw newUoe(MethodReference.class);
  }

  @Override
  protected final MethodReferenceReferenceExpression selfMethodReferenceReferenceExpression() {
    return this;
  }

  @Override
  protected final MultiplicativeExpression selfMultiplicativeExpression() {
    return this;
  }

  @Override
  protected final PostfixExpression selfPostfixExpression() {
    return this;
  }

  @Override
  protected final RelationalExpression selfRelationalExpression() {
    return this;
  }

}
