/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.expression;

import br.com.objectos.code.java.element.AbstractForwardingCodeElement;
import br.com.objectos.code.java.element.ImmutableCodeElement;
import br.com.objectos.code.java.type.TypeName;
import br.com.objectos.comuns.collections.ImmutableList;
import br.com.objectos.comuns.collections.StreamIterable;

public class TypeWitness extends AbstractForwardingCodeElement {

  private static final TypeWitness EMPTY = new TypeWitness(
      ImmutableCodeElement.builder()
          .withOpenAngle()
          .withSpaceOff()
          .withCloseAngle()
          .build()
  );

  private TypeWitness(ImmutableCodeElement delegate) {
    super(delegate);
  }

  static TypeWitness witness0() {
    return EMPTY;
  }

  static TypeWitness witness0(TypeName t1) {
    return witness1(t1);
  }

  static TypeWitness witness0(TypeName t1, TypeName t2) {
    return witness1(t1, t2);
  }

  static TypeWitness witness0(TypeName t1, TypeName t2, TypeName t3) {
    return witness1(t1, t2, t3);
  }

  static TypeWitness witness0(Iterable<? extends TypeName> types) {
    return build0(
        ImmutableCodeElement.builder()
            .withOpenAngle()
            .withSpaceOff()
            .withCommaSeparated(
                StreamIterable.adapt(types).map(AbstractForwardingCodeElement::toCodeElement)
            )
            .withSpaceOff()
            .withCloseAngle()
            .build()
    );
  }

  private static TypeWitness build0(ImmutableCodeElement delegate) {
    return new TypeWitness(delegate);
  }

  private static TypeWitness witness1(TypeName... types) {
    return witness0(ImmutableList.newListWithAll(types));
  }

}
