/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.io;

import br.com.objectos.code.java.declaration.BodyElement;
import br.com.objectos.comuns.collections.GrowableList;
import br.com.objectos.comuns.collections.ImmutableList;
import br.com.objectos.comuns.collections.StreamIterable;

abstract class FormattingAction {

  private final GrowableList<BodyElement> elements = GrowableList.newList();
  private final FormattingAction nextAction;

  FormattingAction(FormattingAction nextAction) {
    this.nextAction = nextAction;
  }

  public abstract void consume(FormattingSource source);

  public abstract void consumeElement(BodyElement element);

  public StreamIterable<BodyElement> stream() {
    return elementsStream().concat(nextAction.stream());
  }

  public final <E extends BodyElement> ImmutableList<E> toImmutableList(Class<E> type) {
    return stream().map(type::cast).toImmutableList();
  }

  StreamIterable<BodyElement> elementsStream() {
    return elements;
  }

  final void nextAction(FormattingSource source) {
    nextAction.consume(source);
  }

  final void storeElement(BodyElement element) {
    elements.add(element);
  }

  public final void propagateElement(BodyElement element) {
    nextAction.consumeElement(element);
  }

}