/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.io;

import br.com.objectos.code.java.declaration.BodyElement;
import br.com.objectos.code.java.element.NewLine;

public class NewLineFormatting extends Formatting {

  private static final NewLineFormatting INSTANCE = new NewLineFormatting();

  private NewLineFormatting() {}

  static Formatting getInstance() {
    return INSTANCE;
  }

  @Override
  final FormattingAction newAction(FormattingAction nextAction) {
    return new NewLineFormattingAction(nextAction);
  }

  public final class NewLineFormattingAction extends FormattingAction {

    private NewLineFormattingAction(FormattingAction nextAction) {
      super(nextAction);
    }

    @Override
    public final void consume(FormattingSource source) {
      outer: while (source.hasElements()) {
        BodyElement element = source.getElement();
        switch (element.kind()) {
          case NEW_LINE:
            continue;
          default:
            storeElement(NewLine.single());
            propagateElement(element);
            break outer;
        }
      }

      nextAction(source);
    }

    @Override
    public final void consumeElement(BodyElement element) {
      element.acceptNewLineFormattingAction(this);
    }

    public final void consumeNewLine(NewLine newLine) {
      storeElement(newLine);
    }

  }

}