/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.statement;

import static br.com.objectos.comuns.lang.Preconditions.checkNotNull;

import br.com.objectos.code.java.expression.ExpressionCode;
import br.com.objectos.code.java.expression.StatementExpression;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.statement.Block.Semicolon;

public class BasicForStatement extends AbstractStatement implements ForStatement {

  private final ForInit init;
  private final ExpressionCode test;
  private final StatementExpression update;
  private final Statement statement;

  private BasicForStatement(ForInit init,
                            ExpressionCode test,
                            StatementExpression update,
                            Statement statement) {
    this.init = init;
    this.test = test;
    this.update = update;
    this.statement = statement;
  }

  static Builder builder(ForInit init, ExpressionCode test, StatementExpression update) {
    checkNotNull(init, "init == null");
    checkNotNull(test, "test == null");
    checkNotNull(update, "update == null");
    return new Builder(init, test, update);
  }

  @Override
  public final CodeWriter acceptCodeWriter(CodeWriter w) {
    w.writeFor(init, test, update);
    w.writeCodeElement(statement);
    return w;
  }

  @Override
  public final void acceptSemicolon(Semicolon semicolon) {
    statement.acceptSemicolon(semicolon);
  }

  public static class Builder {

    private final ForInit init;
    private final ExpressionCode test;
    private final StatementExpression update;

    private Builder(ForInit init, ExpressionCode test, StatementExpression update) {
      this.init = init;
      this.test = test;
      this.update = update;
    }

    public final BasicForStatement block(BlockElement... elements) {
      Block block = Block.of(elements);
      return new BasicForStatement(init, test, update, block);
    }

  }

}
