/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.statement;

import static br.com.objectos.code.java.CodeJava.l;
import static br.com.objectos.comuns.lang.Preconditions.checkNotNull;

import br.com.objectos.code.java.element.AbstractCodeElement;
import br.com.objectos.code.java.element.CodeElement;
import br.com.objectos.code.java.expression.Identifier;
import br.com.objectos.code.java.io.CodeWriter;

public class CaseSwitchElement extends AbstractCodeElement implements SwitchElement {

  private final CodeElement value;

  private CaseSwitchElement(CodeElement value) {
    this.value = value;
  }

  public static CaseSwitchElement _case(int value) {
    return CaseSwitchElement.ofUnchecked(value);
  }

  public static CaseSwitchElement _case(Identifier value) {
    checkNotNull(value, "value == null");
    return CaseSwitchElement.ofUnchecked(value);
  }

  public static CaseSwitchElement _case(String value) {
    checkNotNull(value, "value == null");
    return CaseSwitchElement.ofUnchecked(value);
  }

  static CaseSwitchElement ofUnchecked(int value) {
    return new CaseSwitchElement(l(value));
  }

  static CaseSwitchElement ofUnchecked(Identifier value) {
    return new CaseSwitchElement(value);
  }

  static CaseSwitchElement ofUnchecked(String value) {
    return new CaseSwitchElement(l(value));
  }

  @Override
  public final CodeWriter acceptCodeWriter(CodeWriter w) {
    return w.writeWord("case").writeCodeElement(value).spaceOff().write(':');
  }

  public final SwitchElement body(BlockStatement... statements) {
    return SwitchGroup.of(this, statements);
  }

}
